/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.popup;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.mdainfra.mdacs.MdacActionContributionItem;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class MdaInfraContribution
extends CompoundContributionItem {
    public MdaInfraContribution() {
    }

    public MdaInfraContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        IModelingSession modelingSession = MdaInfra.getInstance().getModelingSession();
        if (modelingSession == null) {
            return new IContributionItem[0];
        }
        IMdacRegistry mdacRegistry = modelingSession.getMdacRegistry();
        Collection activeMdacs = mdacRegistry.getStartedMdacs();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Separator("MDACMenus"));
        IElement[] selectedElements = this.getSelectedElements().toArray(new IElement[0]);
        for (IMdac mdac : activeMdacs) {
            IMenuManager creationmenu = this.buildCreationMenu(mdac);
            list.add(creationmenu);
            IMenuManager menu = this.buildModuleMenu(mdac);
            list.add(menu);
            HashMap<String, IMenuManager> slotMap = new HashMap<String, IMenuManager>();
            List mdacActions = mdac.getActions(ActionLocation.contextualpopup);
            for (IMdacAction mdacAction : mdacActions) {
                if (!mdacAction.accept(selectedElements)) continue;
                List slots = mdacAction.getSlots();
                if (!slots.isEmpty()) {
                    IMenuManager menuOwner = menu;
                    IMenuManager subIMenuManager = menu;
                    String slotCompleteName = "";
                    for (String slotSimpleName : slots) {
                        subIMenuManager = (IMenuManager)slotMap.get(slotCompleteName = String.valueOf(slotCompleteName) + (slotCompleteName.isEmpty() ? "" : "|") + slotSimpleName);
                        if (subIMenuManager == null) {
                            subIMenuManager = new MenuManager(slotSimpleName, mdacAction.getSlotImage(slots.indexOf(slotSimpleName)), null);
                            slotMap.put(slotCompleteName, subIMenuManager);
                        }
                        menuOwner.add((IContributionItem)subIMenuManager);
                        menuOwner = subIMenuManager;
                    }
                    subIMenuManager.add((IContributionItem)MdacActionContributionItem.create((IMdacAction)mdacAction));
                    continue;
                }
                menu.add((IContributionItem)MdacActionContributionItem.create((IMdacAction)mdacAction));
            }
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    private IMenuManager buildModuleMenu(IMdac mdac) {
        return new MenuManager(mdac.getLabel(), mdac.getMdacImageDescriptor(), null);
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                IElement element;
                if (!(selectedObject instanceof IAdaptable) || (element = (IElement)((IAdaptable)selectedObject).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements;
    }

    private IMenuManager buildCreationMenu(IMdac mdac) {
        return new MenuManager(MdaInfra.I18N.getMessage("element_creation_popup_menu", new String[]{mdac.getLabel()}), mdac.getMdacImageDescriptor(), null);
    }
}

