/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.popup;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.mdac.commands.ActionLocation;
import com.modeliosoft.modelio.api.mdac.commands.IMdacAction;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.mdainfra.mdacs.MdacActionContributionItem;
import com.modeliosoft.modelio.mdainfra.plugin.MdaInfra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

public class MdaInfraToolbarContribution
extends ContributionItem {
    private IContributionItem[] items;

    public MdaInfraToolbarContribution() {
    }

    public MdaInfraToolbarContribution(String id) {
        super(id);
    }

    private IContributionItem[] getContributionItems() {
        IModelingSession session = MdaInfra.getInstance().getModelingSession();
        if (session == null) {
            return null;
        }
        IElement[] selectedElements = this.getSelectedElements().toArray(new IElement[0]);
        IMdacRegistry mdacRegistry = session.getMdacRegistry();
        Collection activeMdacs = mdacRegistry.getStartedMdacs();
        ArrayList<MdacActionContributionItem> list = new ArrayList<MdacActionContributionItem>();
        for (IMdac mdac : activeMdacs) {
            HashMap slotMap = new HashMap();
            List mdacActions = mdac.getActions(ActionLocation.toolbar);
            for (IMdacAction mdacAction : mdacActions) {
                list.add(MdacActionContributionItem.create((IMdacAction)mdacAction));
            }
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    public void fill(Menu menu, int index) {
        super.fill(menu, index);
    }

    public void fill(Composite parent) {
        super.fill(parent);
    }

    public void fill(ToolBar toolbar, int index) {
        this.disposeOldItems();
        this.items = this.getContributionItems();
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                IContributionItem item = this.items[i];
                if (item.isVisible()) {
                    item.fill(toolbar, -1);
                }
                ++i;
            }
        }
    }

    private void disposeOldItems() {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                IContributionItem oldItem = this.items[i];
                oldItem.dispose();
                ++i;
            }
            this.items = null;
        }
    }

    public boolean isDynamic() {
        return true;
    }

    private List<IElement> getSelectedElements() {
        ArrayList<IElement> selectedElements = new ArrayList<IElement>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : ((IStructuredSelection)selection).toList()) {
                IElement element;
                if (!(selectedObject instanceof IAdaptable) || (element = (IElement)((IAdaptable)selectedObject).getAdapter(IElement.class)) == null) continue;
                selectedElements.add(element);
            }
        }
        return selectedElements;
    }
}

