/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.combinedfragment.primarynode;

import com.modeliosoft.modelio.diagram.elements.core.figures.IPenOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.PenOptions;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Display;

public class OperatorLabel
extends Label
implements IPenOptionsSupport {
    protected PenOptions penOptions = new PenOptions();

    public OperatorLabel() {
    }

    public OperatorLabel(String s) {
        super(s);
    }

    public Color getLineColor() {
        return this.penOptions.lineColor;
    }

    public int getLineWidth() {
        return this.penOptions.lineWidth;
    }

    public Color getTextColor() {
        return this.penOptions.textColor;
    }

    public Font getTextFont() {
        return this.penOptions.textFont;
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor != lineColor) {
            this.penOptions.lineColor = lineColor;
            this.repaint();
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth != lineWidth) {
            this.penOptions.lineWidth = lineWidth;
            this.repaint();
        }
    }

    public void setTextColor(Color textColor) {
        if (this.penOptions.textColor != textColor) {
            this.penOptions.textColor = textColor;
            this.repaint();
        }
    }

    public void setTextFont(Font textFont) {
        if (this.penOptions.textFont != textFont) {
            this.penOptions.textFont = textFont;
            this.repaint();
        }
    }

    public StyleKey.LinePattern getLinePattern() {
        return this.penOptions.linePattern;
    }

    public void setLinePattern(StyleKey.LinePattern lineStyle) {
        if (this.penOptions.linePattern != lineStyle) {
            this.penOptions.linePattern = lineStyle;
            this.repaint();
        }
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle boundsRect = this.getBounds();
        if (this.penOptions.textColor != null) {
            graphics.setForegroundColor(this.penOptions.textColor);
        }
        if (this.penOptions.textFont != null) {
            graphics.setFont(this.penOptions.textFont);
        }
        graphics.pushState();
        try {
            if (this.isOpaque()) {
                Rectangle originalClip = new Rectangle();
                graphics.getClip(originalClip);
                Path path = new Path((Device)Display.getCurrent());
                path.moveTo((float)boundsRect.x, (float)boundsRect.y);
                path.lineTo((float)boundsRect.x, (float)boundsRect.bottom());
                path.lineTo((float)(boundsRect.right() - 6), (float)boundsRect.bottom());
                path.lineTo((float)boundsRect.right(), (float)(boundsRect.bottom() - 6));
                path.lineTo((float)boundsRect.right(), (float)boundsRect.y);
                path.lineTo((float)boundsRect.x, (float)boundsRect.y);
                graphics.setClip(path);
                graphics.fillRectangle(this.getBounds());
                path.dispose();
                graphics.setClip(originalClip);
            }
            graphics.translate(boundsRect.x, boundsRect.y);
            if (this.getIcon() != null) {
                graphics.drawImage(this.getIcon(), this.getIconLocation());
            }
            if (!this.isEnabled()) {
                graphics.translate(1, 1);
                graphics.setForegroundColor(ColorConstants.buttonLightest);
                graphics.drawText(this.getSubStringText(), this.getTextLocation());
                graphics.translate(-1, -1);
                graphics.setForegroundColor(ColorConstants.buttonDarker);
            }
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-boundsRect.x, -boundsRect.y);
            if (this.penOptions.lineColor != null) {
                graphics.setForegroundColor(this.penOptions.lineColor);
            }
            if (this.penOptions.lineWidth > 0) {
                graphics.setLineWidth(this.penOptions.lineWidth);
            }
            if (this.penOptions.linePattern != null) {
                graphics.setLineStyle(this.penOptions.linePattern.toSWTConstant());
            }
            PointList polygon = new PointList(4);
            Rectangle rect = this.getBounds().getExpanded(-1, -1);
            polygon.addPoint(rect.getBottomLeft().getTranslated(-1, 0));
            polygon.addPoint(rect.getBottomRight().getTranslated(-5, 0));
            polygon.addPoint(rect.getBottomRight().getTranslated(0, -5));
            polygon.addPoint(rect.getTopRight().getTranslated(0, -1));
            graphics.drawPolyline(polygon);
        }
        finally {
            graphics.popState();
        }
    }
}

