/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.executionspecification;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateExecutionSpecificationCommand
extends Command {
    private Rectangle initialLayoutData;
    private GmCompositeNode parentNode;

    public CreateExecutionSpecificationCommand(GmCompositeNode parentNode, Rectangle initialLayoutData) {
        this.initialLayoutData = initialLayoutData;
        this.parentNode = parentNode;
    }

    public void execute() {
        IElement parentElement = this.parentNode.getRelatedIElement();
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IModelFactory modelFactory = diagram.getModelFactory();
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        IInteraction interaction = null;
        ILifeline lifeline = null;
        if (parentElement instanceof ILifeline) {
            lifeline = (ILifeline)parentElement;
            interaction = lifeline.getOwner();
        } else if (parentElement instanceof IExecutionSpecification) {
            lifeline = (ILifeline)((IExecutionSpecification)parentElement).getCovered().get(0);
            interaction = lifeline.getOwner();
        }
        IExecutionOccurenceSpecification startOccurence = modelFactory.createExecutionOccurenceSpecification();
        startOccurence.setEnclosingInteraction(interaction);
        startOccurence.addCovered(lifeline);
        startOccurence.setLineNumber(this.initialLayoutData.y);
        elementInitializer.initialize((IElement)startOccurence);
        IExecutionOccurenceSpecification finishOccurence = modelFactory.createExecutionOccurenceSpecification();
        finishOccurence.setEnclosingInteraction(interaction);
        finishOccurence.addCovered(lifeline);
        finishOccurence.setLineNumber(this.initialLayoutData.bottom());
        elementInitializer.initialize((IElement)finishOccurence);
        IExecutionSpecification newExecution = modelFactory.createExecutionSpecification();
        newExecution.setEnclosingInteraction(interaction);
        newExecution.addCovered(lifeline);
        newExecution.setStart(startOccurence);
        newExecution.setFinish(finishOccurence);
        elementInitializer.initialize((IElement)newExecution);
        diagram.unmask(this.parentNode, (IElement)startOccurence, (Object)this.initialLayoutData);
        diagram.unmask(this.parentNode, (IElement)finishOccurence, (Object)this.initialLayoutData);
        diagram.unmask(this.parentNode, (IElement)newExecution, (Object)this.initialLayoutData);
    }
}

