/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.executionspecification;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.PlacementConstraint;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ExecutionSpecificationPlacementConstraint
extends PlacementConstraint {
    private IExecutionSpecification execution;
    private static final int MAJOR_VERSION = 0;

    public ExecutionSpecificationPlacementConstraint(IExecutionSpecification execution, int x, int y, int width, int height, GmSequenceDiagram diagram) {
        super(x, y, width, height, diagram);
        this.execution = execution;
        if (this.execution.isValid()) {
            this.setY(this.execution.getStart().getLineNumber());
            this.setHeight(this.execution.getFinish().getLineNumber() - this.getY());
        }
    }

    public ExecutionSpecificationPlacementConstraint() {
    }

    public Rectangle getUpdatedBounds(IFigure target) {
        Point topLeft = new Point(this.getX(), this.getY());
        topLeft.translate(-5, 0);
        Dimension dimension = new Dimension(target.getPreferredSize().width, this.getHeight());
        return new Rectangle(topLeft, dimension);
    }

    public void read(IDiagramReader reader) {
        super.read(reader);
        this.execution = (IExecutionSpecification)this.resolveRef((ObRef)reader.readProperty("execution"));
        if (this.execution.isValid()) {
            this.setY(this.execution.getStart().getLineNumber());
            this.setHeight(this.execution.getFinish().getLineNumber() - this.getY());
        }
    }

    public void write(IDiagramWriter writer) {
        super.write(writer);
        writer.writeProperty("execution", new ObRef((IElement)this.execution));
    }

    protected int getHeight() {
        if (this.execution.isValid()) {
            this.setHeight(this.execution.getFinish().getLineNumber() - this.getY());
        }
        return super.getHeight();
    }

    protected int getY() {
        if (this.execution.isValid()) {
            this.setY(this.execution.getStart().getLineNumber());
        }
        return super.getY();
    }

    public int getMajorVersion() {
        return 0;
    }
}

