/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.executionspecification;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessageEnd;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.executionspecification.GmExecutionSpecification;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.IsBeforePredicate;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.Predicate;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.TimeReference;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.Variable;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultNodeResizableEditPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class MoveResizeExecutionSpecificationEditPolicy
extends DefaultNodeResizableEditPolicy {
    private Map<TimeReference, Variable> variables = new HashMap();
    private List<Predicate> predicates = new ArrayList();

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        this.computePredicatesForHost();
        this.updateVariablesFromRequest(request);
        if (this.checkAllPredicates()) {
            return super.getResizeCommand(request);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        this.computePredicatesForHost();
        this.updateVariablesFromRequest(request);
        if (this.checkAllPredicates()) {
            return super.getMoveCommand(request);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private void computePredicatesForHost() {
        this.variables.clear();
        this.predicates.clear();
        IExecutionSpecification executionSpecification = ((GmExecutionSpecification)this.getHost().getModel()).getRelatedIElement();
        this.computePredicatesForExecutionOccurrenceSpecification(executionSpecification.getStart());
        this.computePredicatesForExecutionOccurrenceSpecification(executionSpecification.getFinish());
    }

    private void updateVariablesFromRequest(ChangeBoundsRequest request) {
        if (request.getEditParts() == null) {
            return;
        }
        for (Object obj : request.getEditParts()) {
            int newLineNumber;
            IExecutionOccurenceSpecification otherEnd;
            GraphicalEditPart editPart = (GraphicalEditPart)obj;
            if (editPart == null) continue;
            GmModel model = (GmModel)editPart.getModel();
            Variable variable1 = (Variable)this.variables.get(new TimeReference(model.getRelatedIElement()));
            if (model.getRelatedIElement() instanceof IMessageEnd && variable1 != null) {
                int newLineNumber2 = ((IMessageEnd)model.getRelatedIElement()).getLineNumber();
                variable1.setValue(newLineNumber2 += request.getMoveDelta().y);
                continue;
            }
            if (model.getRelatedIElement() instanceof IExecutionSpecification) {
                int newLineNumber3;
                IExecutionSpecification executionSpecification = (IExecutionSpecification)model.getRelatedIElement();
                if (variable1 != null) {
                    newLineNumber3 = executionSpecification.getLineNumber();
                    variable1.setValue(newLineNumber3 += request.getMoveDelta().y);
                }
                if ((variable1 = (Variable)this.variables.get(new TimeReference((IElement)executionSpecification.getStart()))) != null) {
                    newLineNumber3 = executionSpecification.getStart().getLineNumber();
                    variable1.setValue(newLineNumber3 += request.getMoveDelta().y);
                }
                if ((variable1 = (Variable)this.variables.get(new TimeReference((IElement)executionSpecification.getFinish()))) == null) continue;
                newLineNumber3 = executionSpecification.getFinish().getLineNumber();
                variable1.setValue(newLineNumber3 += request.getMoveDelta().y + request.getSizeDelta().height);
                continue;
            }
            if (!(model.getRelatedIElement() instanceof IMessage)) continue;
            IMessage message = (IMessage)model.getRelatedIElement();
            variable1 = (Variable)this.variables.get(new TimeReference((IElement)message.getSendEvent()));
            if (variable1 != null) {
                int newLineNumber4 = message.getSendEvent().getLineNumber();
                variable1.setValue(newLineNumber4 += request.getMoveDelta().y);
            }
            if ((variable1 = (Variable)this.variables.get(new TimeReference((IElement)message.getReceiveEvent()))) != null) {
                int newLineNumber5 = message.getReceiveEvent().getLineNumber();
                variable1.setValue(newLineNumber5 += request.getMoveDelta().y);
            }
            if (message.getSendEvent() instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)message.getSendEvent()).getStarted() != null && (variable1 = (Variable)this.variables.get(new TimeReference((IElement)(otherEnd = ((IExecutionOccurenceSpecification)message.getSendEvent()).getStarted().getFinish())))) != null) {
                newLineNumber = otherEnd.getLineNumber();
                variable1.setValue(newLineNumber += request.getMoveDelta().y);
            }
            if (!(message.getReceiveEvent() instanceof IExecutionOccurenceSpecification) || ((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted() == null || (variable1 = (Variable)this.variables.get(new TimeReference((IElement)(otherEnd = ((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted().getFinish())))) == null) continue;
            newLineNumber = otherEnd.getLineNumber();
            variable1.setValue(newLineNumber += request.getMoveDelta().y);
        }
    }

    private boolean checkAllPredicates() {
        for (Predicate predicate : this.predicates) {
            if (predicate.evaluate()) continue;
            return false;
        }
        return true;
    }

    private void computePredicatesForExecutionOccurrenceSpecification(IExecutionOccurenceSpecification executionOccurrenceSpecification) {
        IsBeforePredicate predicate;
        Variable variable2;
        TimeReference otherEndTimeReference;
        IExecutionOccurenceSpecification otherEnd;
        TimeReference timeReference = new TimeReference((IElement)executionOccurrenceSpecification);
        Variable variable = (Variable)this.variables.get(timeReference);
        if (variable == null) {
            variable = new Variable();
            variable.setValue(executionOccurrenceSpecification.getLineNumber());
            this.variables.put(timeReference, variable);
        }
        if (executionOccurrenceSpecification.getStarted() != null) {
            otherEnd = executionOccurrenceSpecification.getStarted().getFinish();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable, variable2, 0, true);
            this.predicates.add(predicate);
        }
        if (executionOccurrenceSpecification.getFinished() != null) {
            otherEnd = executionOccurrenceSpecification.getFinished().getStart();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable2, variable, 0, true);
            this.predicates.add(predicate);
        }
        if (executionOccurrenceSpecification.getSentMessage() != null) {
            otherEnd = executionOccurrenceSpecification.getSentMessage().getReceiveEvent();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable, variable2, 0, false);
            this.predicates.add(predicate);
        }
        if (executionOccurrenceSpecification.getReceivedMessage() != null) {
            otherEnd = executionOccurrenceSpecification.getReceivedMessage().getSendEvent();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable2, variable, 0, false);
            this.predicates.add(predicate);
        }
    }
}

