/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.executionspecification;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.executionspecification.GmExecutionSpecification;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.gef.commands.Command;

public class ReparentExecutionSpecificationCommand
extends Command {
    private GmCompositeNode newParentNode;
    private GmExecutionSpecification reparentedChild;
    private int finishTime;
    private int startTime;

    public ReparentExecutionSpecificationCommand(GmCompositeNode newParent, GmExecutionSpecification reparentedChild, int startTime, int finishTime) {
        this.newParentNode = newParent;
        this.reparentedChild = reparentedChild;
        this.startTime = startTime;
        this.finishTime = finishTime;
    }

    public boolean canExecute() {
        IExecutionSpecification childElement = this.reparentedChild.getRelatedIElement();
        if (childElement == null || !childElement.getElementStatus().isModifiable()) {
            return false;
        }
        IExecutionOccurenceSpecification start = childElement.getStart();
        if (start == null || !start.getElementStatus().isModifiable()) {
            return false;
        }
        IExecutionOccurenceSpecification finish = childElement.getStart();
        if (finish == null || !finish.getElementStatus().isModifiable()) {
            return false;
        }
        IElement oldParent = this.getOldLifeline();
        IElement newParent = this.getNewLifeline();
        if (newParent == null) {
            return false;
        }
        boolean sameParentInObModel = newParent.equals((Object)oldParent);
        return sameParentInObModel || oldParent.getElementStatus().isModifiable() && newParent.getElementStatus().isModifiable() && CreationExpertRegistry.getExpert(newParent.getClass()).canOwn(newParent, (IElement)childElement, CompositionServices.getCompositionParentDep((IElement)childElement));
    }

    public void execute() {
        GmNodeModel finishGm;
        IExecutionSpecification childElement = this.reparentedChild.getRelatedIElement();
        IElement oldParentElement = this.getOldLifeline();
        String oldParentDep = "CoveredBy";
        IElement newParentElement = this.getNewLifeline();
        boolean sameParentInObModel = newParentElement.equals((Object)childElement.getCompositionOwner());
        if (!sameParentInObModel) {
            Meta meta = new Meta(oldParentElement);
            meta.removeFromDependency(oldParentDep, (IElement)childElement);
            meta.removeFromDependency(oldParentDep, (IElement)childElement.getStart());
            meta.removeFromDependency(oldParentDep, (IElement)childElement.getFinish());
        }
        GmCompositeNode oldParent = (GmCompositeNode)this.reparentedChild.getParent();
        oldParent.removeChild((GmNodeModel)this.reparentedChild);
        GmNodeModel startGm = oldParent.getChild(new ObRef((IElement)childElement.getStart()));
        if (startGm != null) {
            oldParent.removeChild(startGm);
        }
        if ((finishGm = oldParent.getChild(new ObRef((IElement)childElement.getFinish()))) != null) {
            oldParent.removeChild(finishGm);
        }
        if (!sameParentInObModel) {
            Meta meta = new Meta(newParentElement);
            try {
                meta.appendToDependency(oldParentDep, (IElement)childElement);
                meta.appendToDependency(oldParentDep, (IElement)childElement.getStart());
                meta.appendToDependency(oldParentDep, (IElement)childElement.getFinish());
            }
            catch (InvalidModelManipulationException e) {
                String newParentDep = CompositionExpert.getDefaultCompositionDep((IElement)newParentElement, (IElement)childElement);
                meta.appendToDependency(newParentDep, (IElement)childElement);
                meta.appendToDependency(newParentDep, (IElement)childElement.getStart());
                meta.appendToDependency(newParentDep, (IElement)childElement.getFinish());
            }
        }
        this.newParentNode.addChild((GmNodeModel)this.reparentedChild);
        if (startGm != null) {
            this.newParentNode.addChild(startGm);
        }
        if (finishGm != null) {
            this.newParentNode.addChild(finishGm);
        }
        IExecutionSpecification execution = this.reparentedChild.getRelatedIElement();
        execution.getStart().setLineNumber(this.startTime);
        execution.setLineNumber(this.startTime);
        execution.getFinish().setLineNumber(this.finishTime);
    }

    private IElement getNewLifeline() {
        IElement newParentNodeElement = this.newParentNode.getRelatedIElement();
        if (newParentNodeElement instanceof ILifeline) {
            return newParentNodeElement;
        }
        if (newParentNodeElement instanceof IExecutionSpecification) {
            return (IElement)((IExecutionSpecification)newParentNodeElement).getCovered().get(0);
        }
        return null;
    }

    private IElement getOldLifeline() {
        IElement oldParentNodeElement = this.reparentedChild.getParent().getRelatedIElement();
        if (oldParentNodeElement instanceof ILifeline) {
            return oldParentNodeElement;
        }
        if (oldParentNodeElement instanceof IExecutionSpecification) {
            return (IElement)((IExecutionSpecification)oldParentNodeElement).getCovered().get(0);
        }
        return null;
    }
}

