/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.gate;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IGate;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import org.eclipse.gef.commands.Command;

public class CreateGateCommand
extends Command {
    private Object constraint;
    private ModelioCreationContext context;
    private IInteraction parentElement;
    private GmCompositeNode parentNode;
    private int time;

    public CreateGateCommand(IInteraction parentElement, GmCompositeNode parentNode, ModelioCreationContext context, Object constraint, int time) {
        this.parentNode = parentNode;
        this.parentElement = parentElement;
        this.context = context;
        this.constraint = constraint;
        this.time = time;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IGate newElement = (IGate)this.context.getElementToUnmask();
        if (newElement == null) {
            IModelFactory modelFactory = diagram.getModelFactory();
            newElement = modelFactory.createGate();
            String effectiveDependency = "FormalGate";
            Meta meta = new Meta((IElement)this.parentElement);
            try {
                meta.appendToDependency(effectiveDependency, (IElement)newElement);
            }
            catch (InvalidModelManipulationException e) {
                modelFactory.deleteElement((IElement)newElement);
                return;
            }
            if (this.context.getStereotype() != null) {
                newElement.addExtension(this.context.getStereotype());
            }
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            elementInitializer.initialize((IElement)newElement, this.context.getProperties());
            newElement.setEnclosingInteraction(this.parentElement);
            newElement.setLineNumber(this.time);
        }
        diagram.unmask(this.parentNode, (IElement)newElement, this.constraint);
    }

    protected Object getConstraint() {
        return this.constraint;
    }

    protected ModelioCreationContext getContext() {
        return this.context;
    }

    protected IElement getParentElement() {
        return this.parentElement;
    }

    protected GmCompositeNode getParentNode() {
        return this.parentNode;
    }
}

