/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.interactionoperand;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ICombinedFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionOperand;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class CreateInteractionOperandCommand
extends Command {
    private int newConstraint;
    private ModelioCreationContext context;
    private GmNodeModel insertAfter;
    private ICombinedFragment parentElement;
    private GmCompositeNode parentNode;

    public CreateInteractionOperandCommand(EditPart parentEditPart, ModelioCreationContext context, GmNodeModel insertAfter, int newConstraint) {
        this.parentNode = (GmCompositeNode)parentEditPart.getModel();
        this.parentElement = (ICombinedFragment)this.parentNode.getRelatedIElement();
        this.context = context;
        this.insertAfter = insertAfter;
        this.newConstraint = newConstraint;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IElement newElement = this.context.getElementToUnmask();
        if (newElement != null) {
            this.unmaskAdditionalChild(diagram, newElement);
        } else {
            this.executeCreation(diagram);
        }
    }

    private void executeCreation(GmAbstractDiagram diagram) {
        IModelFactory modelFactory = diagram.getModelFactory();
        IInteractionOperand newElement = (IInteractionOperand)modelFactory.createElement(this.context.getMetaclass());
        if (this.context.getStereotype() != null) {
            newElement.addExtension(this.context.getStereotype());
        }
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        elementInitializer.initialize((IElement)newElement, this.context.getProperties());
        newElement.setEnclosingInteraction(this.parentElement.getEnclosingInteraction());
        if (this.insertAfter == null) {
            int endLine = this.parentElement.getLineNumber();
            for (IInteractionOperand operand : this.parentElement.getOperand()) {
                if (operand.getEndLineNumber() <= endLine) continue;
                endLine = operand.getEndLineNumber();
            }
            this.parentElement.addOperand(newElement);
            newElement.setLineNumber(endLine + 1);
            newElement.setEndLineNumber(endLine + this.newConstraint);
        } else {
            IInteractionOperand referenceOperand = (IInteractionOperand)this.insertAfter.getRelatedIElement();
            int indexOfReference = this.parentElement.getOperand().indexOf((Object)referenceOperand);
            int lineNumber = referenceOperand.getLineNumber();
            for (IInteractionOperand operand : this.parentElement.getOperand()) {
                if (operand.getLineNumber() < lineNumber) continue;
                operand.setLineNumber(operand.getLineNumber() + this.newConstraint + 1);
                operand.setEndLineNumber(operand.getEndLineNumber() + this.newConstraint + 1);
            }
            ArrayList<Object> reorderedOperands = new ArrayList<Object>(this.parentElement.cardOperand() + 1);
            int i = 0;
            while (i < indexOfReference) {
                reorderedOperands.add((IElement)this.parentElement.getOperand().get(i));
                ++i;
            }
            reorderedOperands.add(newElement);
            i = indexOfReference;
            while (i < this.parentElement.cardOperand()) {
                reorderedOperands.add((IElement)this.parentElement.getOperand().get(i));
                ++i;
            }
            this.parentElement.addOperand(newElement);
            newElement.setLineNumber(lineNumber);
            newElement.setEndLineNumber(lineNumber + this.newConstraint);
            ModelServices.reorderDep((IElement)this.parentElement, (String)"Operand", reorderedOperands);
        }
        this.unmaskAdditionalChild(diagram, (IElement)newElement);
    }

    private GmCompositeNode unmaskAdditionalChild(GmAbstractDiagram diagram, IElement newElement) {
        GmCompositeNode newChild = (GmCompositeNode)diagram.unmask(this.parentNode, newElement, (Object)this.newConstraint);
        this.parentNode.moveChild((GmNodeModel)newChild, this.parentNode.getChildren().indexOf(this.insertAfter));
        return newChild;
    }
}

