/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.interactionuse;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionUse;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.lifeline.GmLifeline;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateInteractionUseCommand
extends Command {
    private Rectangle constraint;
    private ModelioCreationContext context;
    private List<GmLifeline> coveredLifelines;
    private GmSequenceDiagram diagram;
    private static final int DEFAULT_SIZE = 70;

    public CreateInteractionUseCommand(GmSequenceDiagram diagram, ModelioCreationContext context, Rectangle constraint, List<GmLifeline> coveredLifelines) {
        this.diagram = diagram;
        this.context = context;
        this.constraint = constraint;
        this.coveredLifelines = coveredLifelines;
    }

    public void execute() {
        IInteractionUse newElement = (IInteractionUse)this.context.getElementToUnmask();
        if (newElement == null) {
            IModelElement parentElement = ((IAbstractDiagram)this.diagram.getRelatedIElement()).getOrigin();
            IModelFactory modelFactory = this.diagram.getModelFactory();
            newElement = (IInteractionUse)modelFactory.createElement(this.context.getMetaclass());
            String effectiveDependency = this.context.getDependency();
            if (effectiveDependency == null) {
                effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)parentElement, (IElement)newElement);
            }
            Meta meta = new Meta((IElement)parentElement);
            try {
                meta.appendToDependency(effectiveDependency, (IElement)newElement);
            }
            catch (InvalidModelManipulationException e) {
                String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)parentElement, (IElement)newElement);
                if (compositionDep != null && !compositionDep.equals("")) {
                    meta.appendToDependency(compositionDep, (IElement)newElement);
                }
                modelFactory.deleteElement((IElement)newElement);
                return;
            }
            if (this.context.getStereotype() != null) {
                newElement.addExtension(this.context.getStereotype());
            }
            IElementInitializer elementInitializer = this.diagram.getElementInitializer();
            elementInitializer.initialize((IElement)newElement, this.context.getProperties());
            for (GmLifeline gmLifeline : this.coveredLifelines) {
                ILifeline lifeline = gmLifeline.getRelatedIElement();
                if (lifeline == null || !lifeline.isValid()) continue;
                newElement.addCovered(lifeline);
            }
            newElement.setLineNumber(this.constraint.y);
            if (this.constraint.bottom() > this.constraint.y) {
                newElement.setEndLineNumber(this.constraint.bottom());
            } else {
                newElement.setEndLineNumber(this.constraint.y + 70);
            }
        }
        this.diagram.unmask((GmCompositeNode)this.diagram, (IElement)newElement, (Object)this.constraint);
    }
}

