/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.lifeline;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionOperand;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionUse;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObMessageSortEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateInvariant;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.PlacementConstraint;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class LifelinePlacementConstraint
extends PlacementConstraint {
    private ILifeline lifeline;
    private static final int ADDITIONAL_SPACE_AT_BOTTOM = 150;
    private static final int DEFAULT_MIN_HEIGHT = 400;
    private IFigure tmpFig;
    private static final int MAJOR_VERSION = 0;

    public LifelinePlacementConstraint(ILifeline lifeline, int x, int y, int width, int height, GmSequenceDiagram diagram) {
        super(x, y, width, height, diagram);
        this.lifeline = lifeline;
    }

    public LifelinePlacementConstraint() {
    }

    public Rectangle getUpdatedBounds(IFigure target) {
        this.tmpFig = target;
        int preferredWidth = target.getPreferredSize().width;
        if (this.getWidth() < preferredWidth) {
            this.setWidth(preferredWidth);
        }
        Rectangle ret = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.tmpFig = null;
        return ret;
    }

    public void read(IDiagramReader reader) {
        super.read(reader);
        this.lifeline = (ILifeline)this.resolveRef((ObRef)reader.readProperty("lifeline"));
    }

    public void write(IDiagramWriter writer) {
        super.write(writer);
        writer.writeProperty("lifeline", new ObRef((IElement)this.lifeline));
    }

    protected int getHeight() {
        for (IExecutionOccurenceSpecification blueSquare : this.lifeline.getCoveredBy(IExecutionOccurenceSpecification.class)) {
            if (blueSquare.getReceivedMessage() == null || blueSquare.getReceivedMessage().getSortOfMessage() != ObMessageSortEnum.DESTROY_MESSAGE) continue;
            return blueSquare.getLineNumber() - this.getY() + 10;
        }
        IInteraction interaction = this.lifeline.getOwner();
        int lastLine = 0;
        for (IInteractionFragment fragment : interaction.getFragment()) {
            if (fragment.getLineNumber() > lastLine) {
                lastLine = fragment.getLineNumber();
            }
            if (fragment instanceof IInteractionUse && ((IInteractionUse)fragment).getEndLineNumber() > lastLine) {
                lastLine = ((IInteractionUse)fragment).getEndLineNumber();
            }
            if (fragment instanceof IInteractionOperand && ((IInteractionOperand)fragment).getEndLineNumber() > lastLine) {
                lastLine = ((IInteractionOperand)fragment).getEndLineNumber();
            }
            if (!(fragment instanceof IStateInvariant) || ((IStateInvariant)fragment).getEndLineNumber() <= lastLine) continue;
            lastLine = fragment.getLineNumber();
        }
        int bottom = lastLine + 150;
        bottom = bottom > 400 ? bottom : 400;
        return bottom - this.getY();
    }

    protected int getY() {
        for (IExecutionOccurenceSpecification blueSquare : this.lifeline.getCoveredBy(IExecutionOccurenceSpecification.class)) {
            if (blueSquare.getReceivedMessage() == null || blueSquare.getReceivedMessage().getSortOfMessage() != ObMessageSortEnum.CREATE_MESSAGE) continue;
            int offset = this.tmpFig != null ? (this.tmpFig.getChildren().size() > 0 ? ((IFigure)this.tmpFig.getChildren().get((int)0)).getPreferredSize().height / 2 : 0) : 0;
            return blueSquare.getLineNumber() - offset;
        }
        return 0;
    }

    public int getMajorVersion() {
        return 0;
    }
}

