/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.lifeline.body;

import com.modeliosoft.modelio.diagram.elements.core.figures.IPenOptionsSupport;
import com.modeliosoft.modelio.diagram.elements.core.figures.PenOptions;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class LifelineBodyFigure
extends Figure
implements IPenOptionsSupport {
    protected PenOptions penOptions = new PenOptions();
    private static final int NEAR_LINE = 10;

    public boolean containsPoint(int x, int y) {
        for (Object childObj : this.getChildren()) {
            IFigure childFigure = (IFigure)childObj;
            if (!childFigure.containsPoint(x, y)) continue;
            return true;
        }
        int centerX = this.getBounds().getCenter().x;
        return this.getBounds().contains(x, y) && centerX - 10 <= x && x <= centerX + 10;
    }

    public Color getLineColor() {
        return this.penOptions.lineColor;
    }

    public StyleKey.LinePattern getLinePattern() {
        return this.penOptions.linePattern;
    }

    public int getLineWidth() {
        return this.penOptions.lineWidth;
    }

    public Color getTextColor() {
        return this.penOptions.textColor;
    }

    public Font getTextFont() {
        return this.penOptions.textFont;
    }

    public void setLineColor(Color lineColor) {
        if (this.penOptions.lineColor != lineColor) {
            this.penOptions.lineColor = lineColor;
            this.repaint();
        }
    }

    public void setLinePattern(StyleKey.LinePattern lineStyle) {
        if (this.penOptions.linePattern != lineStyle) {
            this.penOptions.linePattern = lineStyle;
        }
    }

    public void setLineWidth(int lineWidth) {
        if (this.penOptions.lineWidth != lineWidth) {
            this.penOptions.lineWidth = lineWidth;
            this.repaint();
        }
    }

    public void setTextColor(Color textColor) {
        if (this.penOptions.textColor != textColor) {
            this.penOptions.textColor = textColor;
        }
    }

    public void setTextFont(Font textFont) {
        if (this.penOptions.textFont != textFont) {
            this.penOptions.textFont = textFont;
        }
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setForegroundColor(this.penOptions.lineColor);
            graphics.setLineStyle(2);
            graphics.setLineWidth(this.penOptions.lineWidth);
            graphics.drawLine(this.getBounds().getTop(), this.getBounds().getBottom());
        }
        graphics.restoreState();
    }
}

