/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.lifeline.body;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.executionoccurencespecification.GmExecutionOccurenceSpecification;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.gef.commands.Command;

public class ReparentBlueSquareCommand
extends Command {
    private GmCompositeNode newParentNode;
    private GmExecutionOccurenceSpecification reparentedChild;
    private int newTime;

    public ReparentBlueSquareCommand(GmCompositeNode newParent, GmExecutionOccurenceSpecification reparentedChild, int newTime) {
        this.newParentNode = newParent;
        this.reparentedChild = reparentedChild;
        this.newTime = newTime;
    }

    public boolean canExecute() {
        IExecutionOccurenceSpecification childElement = (IExecutionOccurenceSpecification)this.reparentedChild.getRelatedIElement();
        if (childElement == null || !childElement.getElementStatus().isModifiable()) {
            return false;
        }
        IExecutionSpecification start = childElement.getStarted();
        if (start != null && !start.getElementStatus().isModifiable()) {
            return false;
        }
        IExecutionSpecification finish = childElement.getFinished();
        if (finish != null && !finish.getElementStatus().isModifiable()) {
            return false;
        }
        IElement oldParent = this.getOldLifeline();
        IElement newParent = this.getNewLifeline();
        if (newParent == null) {
            return false;
        }
        boolean sameParentInObModel = newParent.equals((Object)oldParent);
        return sameParentInObModel || oldParent.getElementStatus().isModifiable() && newParent.getElementStatus().isModifiable() && CreationExpertRegistry.getExpert(newParent.getClass()).canOwn(newParent, (IElement)childElement, "CoveredBy");
    }

    public void execute() {
        GmNodeModel finishedStartGm;
        GmNodeModel finishedGm;
        GmNodeModel startedFinishGm;
        GmNodeModel startedGm;
        IExecutionOccurenceSpecification childElement;
        block19: {
            childElement = (IExecutionOccurenceSpecification)this.reparentedChild.getRelatedIElement();
            IElement oldParentElement = this.getOldLifeline();
            String oldParentDep = "CoveredBy";
            IElement newParentElement = this.getNewLifeline();
            boolean sameParentInObModel = newParentElement.equals((Object)childElement.getCompositionOwner());
            if (!sameParentInObModel) {
                Meta meta = new Meta(oldParentElement);
                meta.removeFromDependency(oldParentDep, (IElement)childElement);
                if (childElement.getStarted() != null) {
                    meta.removeFromDependency(oldParentDep, (IElement)childElement.getStarted());
                    meta.removeFromDependency(oldParentDep, (IElement)childElement.getStarted().getFinish());
                }
                if (childElement.getFinished() != null) {
                    meta.removeFromDependency(oldParentDep, (IElement)childElement.getFinished());
                    meta.removeFromDependency(oldParentDep, (IElement)childElement.getFinished().getStart());
                }
            }
            GmCompositeNode oldParent = (GmCompositeNode)this.reparentedChild.getParent();
            oldParent.removeChild((GmNodeModel)this.reparentedChild);
            startedGm = null;
            startedFinishGm = null;
            if (childElement.getStarted() != null) {
                startedGm = oldParent.getChild(new ObRef((IElement)childElement.getStarted()));
                if (startedGm != null) {
                    oldParent.removeChild(startedGm);
                }
                if ((startedFinishGm = oldParent.getChild(new ObRef((IElement)childElement.getStarted().getFinish()))) != null) {
                    oldParent.removeChild(startedFinishGm);
                }
            }
            finishedGm = null;
            finishedStartGm = null;
            if (childElement.getFinished() != null) {
                finishedGm = oldParent.getChild(new ObRef((IElement)childElement.getFinished()));
                if (finishedGm != null) {
                    oldParent.removeChild(finishedGm);
                }
                if ((finishedStartGm = oldParent.getChild(new ObRef((IElement)childElement.getFinished().getStart()))) != null) {
                    oldParent.removeChild(finishedStartGm);
                }
            }
            if (!sameParentInObModel) {
                Meta meta = new Meta(newParentElement);
                try {
                    meta.appendToDependency(oldParentDep, (IElement)childElement);
                    if (childElement.getStarted() != null) {
                        meta.appendToDependency(oldParentDep, (IElement)childElement.getStarted());
                        meta.appendToDependency(oldParentDep, (IElement)childElement.getStarted().getFinish());
                    }
                    if (childElement.getFinished() != null) {
                        meta.appendToDependency(oldParentDep, (IElement)childElement.getFinished());
                        meta.appendToDependency(oldParentDep, (IElement)childElement.getFinished().getStart());
                    }
                }
                catch (InvalidModelManipulationException e) {
                    String newParentDep = CompositionExpert.getDefaultCompositionDep((IElement)newParentElement, (IElement)childElement);
                    meta.appendToDependency(newParentDep, (IElement)childElement);
                    if (childElement.getStarted() != null) {
                        meta.appendToDependency(newParentDep, (IElement)childElement.getStarted());
                        meta.appendToDependency(newParentDep, (IElement)childElement.getStarted().getFinish());
                    }
                    if (childElement.getFinished() == null) break block19;
                    meta.appendToDependency(newParentDep, (IElement)childElement.getFinished());
                    meta.appendToDependency(newParentDep, (IElement)childElement.getFinished().getStart());
                }
            }
        }
        this.newParentNode.addChild((GmNodeModel)this.reparentedChild);
        if (startedGm != null) {
            this.newParentNode.addChild(startedGm);
            this.newParentNode.addChild(startedFinishGm);
        }
        if (finishedGm != null) {
            this.newParentNode.addChild(finishedGm);
            this.newParentNode.addChild(finishedStartGm);
        }
        int delta = this.newTime - childElement.getLineNumber();
        childElement.setLineNumber(this.newTime);
        if (childElement.getStarted() != null) {
            int tmp = childElement.getStarted().getLineNumber() + delta;
            childElement.getStarted().setLineNumber(tmp);
            tmp = childElement.getStarted().getFinish().getLineNumber() + delta;
            childElement.getStarted().getFinish().setLineNumber(tmp);
        }
        if (childElement.getFinished() != null) {
            int tmp = childElement.getFinished().getLineNumber() + delta;
            childElement.getFinished().setLineNumber(tmp);
            tmp = childElement.getFinished().getStart().getLineNumber() + delta;
            childElement.getFinished().getStart().setLineNumber(tmp);
        }
    }

    private IElement getNewLifeline() {
        IElement newParentNodeElement = this.newParentNode.getRelatedIElement();
        if (newParentNodeElement instanceof ILifeline) {
            return newParentNodeElement;
        }
        if (newParentNodeElement instanceof IExecutionOccurenceSpecification) {
            return (IElement)((IExecutionOccurenceSpecification)newParentNodeElement).getCovered().get(0);
        }
        return null;
    }

    private IElement getOldLifeline() {
        IElement oldParentNodeElement = this.reparentedChild.getParent().getRelatedIElement();
        if (oldParentNodeElement instanceof ILifeline) {
            return oldParentNodeElement;
        }
        if (oldParentNodeElement instanceof IExecutionOccurenceSpecification) {
            return (IElement)((IExecutionOccurenceSpecification)oldParentNodeElement).getCovered().get(0);
        }
        return null;
    }
}

