/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AccessibleAnchorProvider;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class MessageDragTracker
extends SelectEditPartTracker {
    private ConnectionEditPart connectionEditPart;
    private List<Object> exclusionSet;
    private PrecisionPoint sourceRelativeStartPoint;
    private static final int FLAG_SOURCE_FEEBBACK = 256;
    protected static final int MAX_FLAG = 256;
    private String commandName;

    public MessageDragTracker(ConnectionEditPart cep) {
        super((EditPart)cep);
        this.setConnectionEditPart(cep);
        this.setDisabledCursor(Cursors.NO);
    }

    public void commitDrag() {
        this.eraseSourceFeedback();
        this.eraseTargetFeedback();
        this.executeCurrentCommand();
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        this.getCurrentViewer().setFocus(null);
        super.deactivate();
    }

    public void setCommandName(String newCommandName) {
        this.commandName = newCommandName;
    }

    public void setConnectionEditPart(ConnectionEditPart cep) {
        this.connectionEditPart = cep;
    }

    boolean navigateNextAnchor(int direction) {
        EditPart focus = this.getCurrentViewer().getFocusEditPart();
        AccessibleAnchorProvider provider = (AccessibleAnchorProvider)focus.getAdapter(AccessibleAnchorProvider.class);
        if (provider == null) {
            return false;
        }
        List list = provider.getSourceAnchorLocations();
        Point start = this.getLocation();
        int distance = Integer.MAX_VALUE;
        Point next = null;
        int i = 0;
        while (i < list.size()) {
            int d;
            Point p = (Point)list.get(i);
            if (!(p.equals((Object)start) || direction != 0 && start.getPosition(p) != direction || (d = p.getDistanceOrthogonal(start)) >= distance)) {
                distance = d;
                next = p;
            }
            ++i;
        }
        if (next != null) {
            this.placeMouseInViewer(next);
            return true;
        }
        return false;
    }

    protected Cursor calculateCursor() {
        if (this.isInState(19)) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    protected List<?> createOperationSet() {
        if (this.getCurrentViewer() != null) {
            List list = ToolUtilities.getSelectionWithoutDependants((EditPartViewer)this.getCurrentViewer());
            return list;
        }
        return new ArrayList();
    }

    protected Request createTargetRequest() {
        return new ChangeBoundsRequest((Object)this.getCommandName());
    }

    protected void eraseSourceFeedback() {
        if (!this.getFlag(256)) {
            return;
        }
        this.setFlag(256, false);
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        request.setType((Object)"move");
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            editPart.eraseSourceFeedback(this.getTargetRequest());
        }
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("MessageDragTracker");
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        request.setType((Object)"move");
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            command.add(editPart.getCommand(request));
        }
        return command.unwrap();
    }

    protected String getCommandName() {
        return this.commandName;
    }

    protected Connection getConnection() {
        return (Connection)this.getConnectionEditPart().getFigure();
    }

    protected ConnectionEditPart getConnectionEditPart() {
        return this.connectionEditPart;
    }

    protected String getDebugName() {
        return "MessageDragTracker";
    }

    protected Collection<?> getExclusionSet() {
        if (this.exclusionSet == null) {
            this.exclusionSet = new ArrayList();
            this.exclusionSet.add(this.getConnection());
        }
        return this.exclusionSet;
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.executeCurrentCommand();
        }
        return true;
    }

    protected boolean handleDragInProgress() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.showSourceFeedback();
        this.showTargetFeedback();
        this.setCurrentCommand(this.getCommand());
        return true;
    }

    protected boolean handleDragStarted() {
        this.stateTransition(2, 4);
        return false;
    }

    protected boolean handleHover() {
        if (this.isInState(36)) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            if (this.stateTransition(1, 32)) {
                this.getCurrentViewer().setFocus(this.getConnectionEditPart().getSource());
                this.getCurrentViewer().reveal(this.getConnectionEditPart().getSource());
            }
            int direction = 0;
            switch (e.keyCode) {
                case 0x1000002: {
                    direction = 4;
                    break;
                }
                case 0x1000001: {
                    direction = 1;
                    break;
                }
                case 0x1000004: {
                    direction = (this.getCurrentViewer().getControl().getStyle() & 0x8000000) != 0 ? 8 : 16;
                    break;
                }
                case 0x1000003: {
                    direction = (this.getCurrentViewer().getControl().getStyle() & 0x8000000) != 0 ? 16 : 8;
                }
            }
            boolean consumed = false;
            if (direction != 0 && e.stateMask == 0) {
                consumed = this.navigateNextAnchor(direction);
            }
            if (!consumed) {
                e.stateMask |= 0x40000;
                e.stateMask &= 0xFFFDFFFF;
                if (this.getCurrentViewer().getKeyHandler().keyPressed(e)) {
                    this.navigateNextAnchor(0);
                    return true;
                }
            }
        }
        if (e.character == '/' || e.character == '\\') {
            e.stateMask |= 0x40000;
            if (this.getCurrentViewer().getKeyHandler().keyPressed(e)) {
                if (this.getCurrentViewer().getFocusEditPart() != this.getConnectionEditPart()) {
                    this.navigateNextAnchor(0);
                }
                return true;
            }
        }
        return false;
    }

    protected void repairStartLocation() {
        if (this.sourceRelativeStartPoint == null) {
            return;
        }
        IFigure figure = this.getConnectionEditPart().getFigure();
        PrecisionPoint newStart = (PrecisionPoint)this.sourceRelativeStartPoint.getCopy();
        figure.translateToAbsolute((Translatable)newStart);
        this.setStartLocation((Point)newStart);
    }

    protected void setAutoexposeHelper(AutoexposeHelper helper) {
        super.setAutoexposeHelper(helper);
        if (helper != null && this.sourceRelativeStartPoint == null && this.isInState(36)) {
            IFigure figure = this.getConnectionEditPart().getFigure();
            this.sourceRelativeStartPoint = new PrecisionPoint(this.getStartLocation());
            figure.translateToRelative((Translatable)this.sourceRelativeStartPoint);
        }
    }

    protected void showSourceFeedback() {
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        request.setType((Object)"move");
        while (iter.hasNext()) {
            EditPart editPart = (EditPart)iter.next();
            editPart.showSourceFeedback(this.getTargetRequest());
        }
        this.setFlag(256, true);
    }

    protected void updateTargetRequest() {
        this.repairStartLocation();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        Dimension delta = this.getDragMoveDelta();
        if (this.getCurrentInput().isShiftKeyDown()) {
            request.setConstrainedMove(true);
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        } else {
            request.setConstrainedMove(false);
        }
        Point moveDelta = new Point(delta.width, delta.height);
        request.getExtendedData().clear();
        request.setMoveDelta(moveDelta);
        request.setLocation(this.getLocation());
        request.setType((Object)this.getCommandName());
    }
}

