/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.message;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessageEnd;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObMessageSortEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.message.GmMessage;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.message.MessageHandle;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.message.MessageTranslationEditPolicy;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.message.MoveMessageCommand;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.IsBeforePredicate;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.Predicate;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.TimeReference;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.modelmanipulation.Variable;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class MessageTranslationEditPolicy
extends SelectionHandlesEditPolicy {
    private FeedbackHelper feedbackHelper;
    private ConnectionFocus focus;
    private ConnectionAnchor originalSourceAnchor;
    private ConnectionAnchor originalTargetAnchor;
    private XYAnchor dummySourceAnchor = new XYAnchor(new Point(10, 10));
    private XYAnchor dummyTargetAnchor = new XYAnchor(new Point(10, 10));
    private Map<TimeReference, Variable> variables = new HashMap();
    private List<Predicate> predicates = new ArrayList();

    public void eraseSourceFeedback(Request request) {
        if ("Reconnection target".equals(request.getType()) || "Reconnection source".equals(request.getType())) {
            this.eraseConnectionMoveFeedback((ReconnectRequest)request);
        } else if ("move".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public Command getCommand(Request request) {
        Object type = request.getType();
        if ("move".equals(type)) {
            this.computePredicatesForHost();
            this.updateVariablesFromRequest((ChangeBoundsRequest)request);
            if (this.checkAllPredicates()) {
                ((ChangeBoundsRequest)request).getMoveDelta().x = 0;
                GmMessage gmMessage = (GmMessage)this.getHost().getModel();
                MoveMessageCommand moveMessageCommand = new MoveMessageCommand();
                moveMessageCommand.setDiagram(gmMessage.getDiagram());
                moveMessageCommand.setMessage(gmMessage.getRelatedIElement());
                moveMessageCommand.setSourceTimeDelta(((ChangeBoundsRequest)request).getMoveDelta().y);
                moveMessageCommand.setTargetTimeDelta(((ChangeBoundsRequest)request).getMoveDelta().y);
                return moveMessageCommand;
            }
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.showConnectionMoveFeedback((ReconnectRequest)request);
        } else if ("move".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    protected List<ConnectionHandle> createSelectionHandles() {
        ArrayList<ConnectionHandle> list = new ArrayList<ConnectionHandle>();
        list.add((ConnectionHandle)new MessageHandle((ConnectionEditPart)this.getHost(), 3));
        list.add((ConnectionHandle)new MessageHandle((ConnectionEditPart)this.getHost(), 2));
        list.add((ConnectionHandle)new MessageHandle((ConnectionEditPart)this.getHost(), 4));
        return list;
    }

    protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
        if (this.originalSourceAnchor != null) {
            this.getConnection().setSourceAnchor(this.originalSourceAnchor);
        }
        if (this.originalTargetAnchor != null) {
            this.getConnection().setTargetAnchor(this.originalTargetAnchor);
        }
        this.originalSourceAnchor = null;
        this.originalTargetAnchor = null;
        this.feedbackHelper = null;
    }

    protected Connection getConnection() {
        return (Connection)((GraphicalEditPart)this.getHost()).getFigure();
    }

    protected FeedbackHelper getFeedbackHelper(ReconnectRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            this.feedbackHelper.setConnection(this.getConnection());
            this.feedbackHelper.setMovingStartAnchor(request.isMovingStartAnchor());
        }
        return this.feedbackHelper;
    }

    protected void hideFocus() {
        if (this.focus != null) {
            this.removeFeedback((IFigure)this.focus);
            this.focus = null;
        }
    }

    protected void showConnectionMoveFeedback(ReconnectRequest request) {
        NodeEditPart node = null;
        if (request.getTarget() instanceof NodeEditPart) {
            node = (NodeEditPart)request.getTarget();
        }
        if (this.originalSourceAnchor == null) {
            this.originalSourceAnchor = request.isMovingStartAnchor() ? this.getConnection().getSourceAnchor() : this.getConnection().getTargetAnchor();
        }
        ConnectionAnchor anchor = null;
        if (node != null) {
            anchor = request.isMovingStartAnchor() ? node.getSourceConnectionAnchor((Request)request) : node.getTargetConnectionAnchor((Request)request);
        }
        FeedbackHelper helper = this.getFeedbackHelper(request);
        helper.update(anchor, request.getLocation());
    }

    protected void showFocus() {
        if (this.focus == null) {
            this.focus = new ConnectionFocus(this);
            this.addFeedback((IFigure)this.focus);
        }
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest originalRequest) {
        ChangeBoundsRequest request = new ChangeBoundsRequest(originalRequest.getType());
        request.setCenteredResize(originalRequest.isCenteredResize());
        request.setConstrainedMove(originalRequest.isConstrainedMove());
        request.setConstrainedResize(originalRequest.isConstrainedResize());
        request.setEditParts(originalRequest.getEditParts());
        request.setExtendedData(originalRequest.getExtendedData());
        request.setLocation(originalRequest.getLocation().getCopy());
        request.setMoveDelta(new Point(0, originalRequest.getMoveDelta().y));
        request.setResizeDirection(originalRequest.getResizeDirection());
        request.setSizeDelta(originalRequest.getSizeDelta().getCopy());
        GmMessage messageModel = (GmMessage)this.getHost().getModel();
        IMessage message = messageModel.getRelatedIElement();
        IMessageEnd sourceEnd = message.getSendEvent();
        List sourceEndModels = messageModel.getDiagram().getAllGMRelatedTo(new ObRef((IElement)sourceEnd));
        for (GmModel sourceEndModel : sourceEndModels) {
            if (!((GmNodeModel)sourceEndModel).isVisible()) continue;
            ((EditPart)this.getHost().getViewer().getEditPartRegistry().get(sourceEndModel)).showSourceFeedback((Request)request);
        }
        IMessageEnd targetEnd = message.getReceiveEvent();
        List targetEndModels = messageModel.getDiagram().getAllGMRelatedTo(new ObRef((IElement)targetEnd));
        for (GmModel targetEndModel : targetEndModels) {
            if (!((GmNodeModel)targetEndModel).isVisible()) continue;
            ((EditPart)this.getHost().getViewer().getEditPartRegistry().get(targetEndModel)).showSourceFeedback((Request)request);
        }
        if (this.originalSourceAnchor == null) {
            this.originalSourceAnchor = this.getConnection().getSourceAnchor();
        }
        if (this.originalTargetAnchor == null) {
            this.originalTargetAnchor = this.getConnection().getTargetAnchor();
        }
        Point p = this.originalSourceAnchor.getReferencePoint().getCopy();
        p.translate(0, request.getMoveDelta().y);
        this.dummySourceAnchor.setLocation(p);
        p = this.originalTargetAnchor.getReferencePoint().getCopy();
        p.translate(0, request.getMoveDelta().y);
        this.dummyTargetAnchor.setLocation(p);
        this.getConnection().setSourceAnchor((ConnectionAnchor)this.dummySourceAnchor);
        this.getConnection().setTargetAnchor((ConnectionAnchor)this.dummyTargetAnchor);
    }

    private void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        GmMessage messageModel = (GmMessage)this.getHost().getModel();
        IMessage message = messageModel.getRelatedIElement();
        IMessageEnd sourceEnd = message.getSendEvent();
        List sourceEndModels = messageModel.getDiagram().getAllGMRelatedTo(new ObRef((IElement)sourceEnd));
        for (GmModel sourceEndModel : sourceEndModels) {
            if (!((GmNodeModel)sourceEndModel).isVisible()) continue;
            ((EditPart)this.getHost().getViewer().getEditPartRegistry().get(sourceEndModel)).eraseSourceFeedback((Request)request);
        }
        IMessageEnd targetEnd = message.getReceiveEvent();
        List targetEndModels = messageModel.getDiagram().getAllGMRelatedTo(new ObRef((IElement)targetEnd));
        for (GmModel targetEndModel : targetEndModels) {
            if (!((GmNodeModel)targetEndModel).isVisible()) continue;
            ((EditPart)this.getHost().getViewer().getEditPartRegistry().get(targetEndModel)).eraseSourceFeedback((Request)request);
        }
        if (this.originalSourceAnchor != null) {
            this.getConnection().setSourceAnchor(this.originalSourceAnchor);
        }
        if (this.originalTargetAnchor != null) {
            this.getConnection().setTargetAnchor(this.originalTargetAnchor);
        }
        this.originalSourceAnchor = null;
        this.originalTargetAnchor = null;
    }

    public boolean understandsRequest(Request request) {
        return "move".equals(request.getType());
    }

    private void computePredicatesForHost() {
        this.variables.clear();
        this.predicates.clear();
        IMessage message = ((GmMessage)this.getHost().getModel()).getRelatedIElement();
        this.computePredicatesForMessage(message);
    }

    private void updateVariablesFromRequest(ChangeBoundsRequest request) {
        if (request.getEditParts() == null) {
            return;
        }
        for (Object obj : request.getEditParts()) {
            GraphicalEditPart editPart = (GraphicalEditPart)obj;
            if (editPart == null) continue;
            GmModel model = (GmModel)editPart.getModel();
            if (model.getRelatedIElement() instanceof IMessageEnd) {
                this.updateVariablesForMessageEnd((IMessageEnd)model.getRelatedIElement(), request.getMoveDelta().y);
                continue;
            }
            if (model.getRelatedIElement() instanceof IExecutionSpecification) {
                this.updateVariablesForExecutionSpecification((IExecutionSpecification)model.getRelatedIElement(), request.getMoveDelta().y, request.getSizeDelta().height);
                continue;
            }
            if (!(model.getRelatedIElement() instanceof IMessage)) continue;
            this.updateVariablesForMessage(request.getMoveDelta().y, (IMessage)model.getRelatedIElement());
        }
    }

    private boolean checkAllPredicates() {
        for (Predicate predicate : this.predicates) {
            if (predicate.evaluate()) continue;
            return false;
        }
        return true;
    }

    private void computePredicatesForMessageEnd(IMessageEnd messageEnd) {
        IsBeforePredicate predicate;
        Variable variable2;
        TimeReference otherEndTimeReference;
        IExecutionOccurenceSpecification otherEnd;
        TimeReference timeReference = new TimeReference((IElement)messageEnd);
        Variable variable = (Variable)this.variables.get(timeReference);
        if (variable == null) {
            variable = new Variable();
            variable.setValue(messageEnd.getLineNumber());
            this.variables.put(timeReference, variable);
        }
        if (messageEnd instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)messageEnd).getStarted() != null) {
            otherEnd = ((IExecutionOccurenceSpecification)messageEnd).getStarted().getFinish();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable, variable2, 0, true);
            this.predicates.add(predicate);
        }
        if (messageEnd instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)messageEnd).getFinished() != null) {
            otherEnd = ((IExecutionOccurenceSpecification)messageEnd).getFinished().getStart();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable2, variable, 0, true);
            this.predicates.add(predicate);
        }
        if (messageEnd.getSentMessage() != null) {
            otherEnd = messageEnd.getSentMessage().getReceiveEvent();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable, variable2, 0, false);
            this.predicates.add(predicate);
        }
        if (messageEnd.getReceivedMessage() != null) {
            otherEnd = messageEnd.getReceivedMessage().getSendEvent();
            otherEndTimeReference = new TimeReference((IElement)otherEnd);
            variable2 = (Variable)this.variables.get(otherEndTimeReference);
            if (variable2 == null) {
                variable2 = new Variable();
                variable2.setValue(otherEnd.getLineNumber());
                this.variables.put(otherEndTimeReference, variable2);
            }
            predicate = new IsBeforePredicate(variable2, variable, 0, false);
            this.predicates.add(predicate);
        }
    }

    private void computePredicatesForMessage(IMessage message) {
        this.computePredicatesForMessageEnd(message.getSendEvent());
        if (message.getSendEvent() instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)message.getSendEvent()).getStarted() != null) {
            IExecutionOccurenceSpecification finishExecutionOccurrenceSpecification = ((IExecutionOccurenceSpecification)message.getSendEvent()).getStarted().getFinish();
            this.computePredicatesForMessageEnd((IMessageEnd)finishExecutionOccurrenceSpecification);
        }
        this.computePredicatesForMessageEnd(message.getReceiveEvent());
        if (message.getReceiveEvent() instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted() != null) {
            IExecutionOccurenceSpecification finishExecutionOccurenceSpecification = ((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted().getFinish();
            this.computePredicatesForMessageEnd((IMessageEnd)finishExecutionOccurenceSpecification);
            if (finishExecutionOccurenceSpecification.getSentMessage() != null && finishExecutionOccurenceSpecification.getSentMessage().getSortOfMessage() == ObMessageSortEnum.RETURN_MESSAGE) {
                this.computePredicatesForMessage(finishExecutionOccurenceSpecification.getSentMessage());
            }
        }
    }

    private void updateVariablesForMessage(int shift, IMessage message) {
        this.updateVariablesForMessageEnd(message.getSendEvent(), shift);
        this.updateVariablesForMessageEnd(message.getReceiveEvent(), shift);
        if (message.getSendEvent() instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)message.getSendEvent()).getStarted() != null) {
            this.updateVariablesForExecutionSpecification(((IExecutionOccurenceSpecification)message.getSendEvent()).getStarted(), shift, 0);
        }
        if (message.getReceiveEvent() instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted() != null) {
            this.updateVariablesForExecutionSpecification(((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted(), shift, 0);
            IExecutionOccurenceSpecification otherEnd = ((IExecutionOccurenceSpecification)message.getReceiveEvent()).getStarted().getFinish();
            if (otherEnd.getSentMessage() != null && otherEnd.getSentMessage().getSortOfMessage() == ObMessageSortEnum.RETURN_MESSAGE) {
                this.updateVariablesForMessage(shift, otherEnd.getSentMessage());
            }
        }
    }

    private void updateVariablesForExecutionSpecification(IExecutionSpecification executionSpecification, int shift, int sizeDelta) {
        Variable variable1 = (Variable)this.variables.get(new TimeReference((IElement)executionSpecification));
        if (variable1 != null) {
            int newLineNumber = executionSpecification.getLineNumber() + shift;
            variable1.setValue(newLineNumber);
        }
        this.updateVariablesForMessageEnd((IMessageEnd)executionSpecification.getStart(), shift);
        this.updateVariablesForMessageEnd((IMessageEnd)executionSpecification.getFinish(), shift + sizeDelta);
    }

    private void updateVariablesForMessageEnd(IMessageEnd messageEnd, int shift) {
        Variable variable2 = (Variable)this.variables.get(new TimeReference((IElement)messageEnd));
        if (variable2 != null) {
            int newLineNumber = messageEnd.getLineNumber() + shift;
            variable2.setValue(newLineNumber);
        }
    }
}

