/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.message;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionOccurenceSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessageEnd;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObMessageSortEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import org.eclipse.gef.commands.Command;

public class MoveMessageCommand
extends Command {
    private IMessage message;
    private int sourceTimeDelta;
    private int targetTimeDelta;
    private GmAbstractDiagram diagram;

    public void execute() {
        IMessageEnd sendEvent = this.message.getSendEvent();
        sendEvent.setLineNumber(sendEvent.getLineNumber() + this.sourceTimeDelta);
        if (sendEvent instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)sendEvent).getStarted() != null) {
            IExecutionSpecification execution = ((IExecutionOccurenceSpecification)sendEvent).getStarted();
            execution.setLineNumber(execution.getLineNumber() + this.sourceTimeDelta);
            execution.getFinish().setLineNumber(execution.getFinish().getLineNumber() + this.sourceTimeDelta);
        }
        IMessageEnd receiveEvent = this.message.getReceiveEvent();
        receiveEvent.setLineNumber(receiveEvent.getLineNumber() + this.targetTimeDelta);
        if (receiveEvent instanceof IExecutionOccurenceSpecification && ((IExecutionOccurenceSpecification)receiveEvent).getStarted() != null) {
            IExecutionSpecification execution = ((IExecutionOccurenceSpecification)receiveEvent).getStarted();
            execution.setLineNumber(execution.getLineNumber() + this.targetTimeDelta);
            execution.getFinish().setLineNumber(execution.getFinish().getLineNumber() + this.targetTimeDelta);
            if (execution.getFinish().getSentMessage() != null && execution.getFinish().getSentMessage().getSortOfMessage() == ObMessageSortEnum.RETURN_MESSAGE) {
                MoveMessageCommand command = new MoveMessageCommand();
                command.setDiagram(this.diagram);
                command.setMessage(execution.getFinish().getSentMessage());
                command.setSourceTimeDelta(0);
                command.setTargetTimeDelta(this.targetTimeDelta);
                command.execute();
            }
        }
    }

    public void setMessage(IMessage message) {
        this.message = message;
    }

    public void setSourceTimeDelta(int sourceTimeDelta) {
        this.sourceTimeDelta = sourceTimeDelta;
    }

    public void setTargetTimeDelta(int targetTimeDelta) {
        this.targetTimeDelta = targetTimeDelta;
    }

    public boolean canExecute() {
        return AuthHelper.canModifyDiagram((GmAbstractDiagram)this.diagram) && AuthHelper.canModify((IElement)this.message);
    }

    public void setDiagram(GmAbstractDiagram diagram) {
        this.diagram = diagram;
    }
}

