/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.message;

import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import org.eclipse.gef.commands.Command;

public class SmartTypeMessageCommand
extends Command {
    private IMessage messageToType;
    private IOperation operation;
    private ISignal signal;
    private String oldMessageName = "";

    public SmartTypeMessageCommand(IMessage messageToType, IOperation operation) {
        this.messageToType = messageToType;
        this.operation = operation;
    }

    public SmartTypeMessageCommand(IMessage messageToType, ISignal signal) {
        this.messageToType = messageToType;
        this.signal = signal;
    }

    public boolean canExecute() {
        return !(!AuthHelper.canModify((IElement)this.messageToType) || this.operation != null && !AuthHelper.canModify((IElement)this.operation) || this.signal != null && !AuthHelper.canModify((IElement)this.signal));
    }

    public void execute() {
        this.oldMessageName = this.messageToType.getName();
        if (this.operation != null) {
            this.messageToType.setInvoked(this.operation);
            this.messageToType.setName(this.operation.getName());
        } else if (this.signal != null) {
            this.messageToType.setSignalSignature(this.signal);
            this.messageToType.setName(this.signal.getName());
        }
    }

    public void undo() {
        if (this.operation != null) {
            this.messageToType.setInvoked(null);
            this.messageToType.setName(this.oldMessageName);
        } else if (this.signal != null) {
            this.messageToType.setSignalSignature(null);
            this.messageToType.setName(this.oldMessageName);
        }
    }

    public void redo() {
        if (this.operation != null) {
            this.messageToType.setInvoked(this.operation);
            this.messageToType.setName(this.operation.getName());
        } else if (this.signal != null) {
            this.messageToType.setSignalSignature(this.signal);
            this.messageToType.setName(this.signal.getName());
        }
    }
}

