/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IPartDecomposition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.MmHelper;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import org.eclipse.gef.commands.Command;

class CreatePartDecompositionCommand
extends Command {
    private ModelioCreationContext context;
    private Object constraint;
    private IInteraction interaction;
    private GmCompositeNode parentNode;

    public CreatePartDecompositionCommand(IInteraction interaction, GmCompositeNode parentNode, ModelioCreationContext context, Object constraint) {
        this.parentNode = parentNode;
        this.interaction = interaction;
        this.context = context;
        this.constraint = constraint;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IModelFactory modelFactory = diagram.getModelFactory();
        ILifeline lifeline = modelFactory.createLifeline();
        this.interaction.addOwnedLine(lifeline);
        IPartDecomposition partDecomposition = modelFactory.createPartDecomposition();
        lifeline.setDecomposedAs(partDecomposition);
        if (this.context.getStereotype() != null) {
            partDecomposition.addExtension(this.context.getStereotype());
        }
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        elementInitializer.initialize((IElement)lifeline, this.context.getProperties());
        elementInitializer.initialize((IElement)partDecomposition, this.context.getProperties());
        diagram.unmask(this.parentNode, (IElement)lifeline, this.constraint);
    }

    public boolean canExecute() {
        GmAbstractDiagram gmDiagram = this.parentNode.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        if (this.context.getElementToUnmask() == null) {
            if (!AuthHelper.canAdd((IElement)this.interaction, (String)"Lifeline")) {
                return false;
            }
            return MmHelper.canAddTo((IElement)this.interaction, ILifeline.class);
        }
        return true;
    }
}

