/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public abstract class PlacementConstraint
implements IPersistent,
Locator {
    private int height;
    private int width;
    private int x;
    private int y;
    private GmSequenceDiagram diagram;
    private static final int MAJOR_VERSION = 0;

    public PlacementConstraint(int x, int y, int width, int height, GmSequenceDiagram diagram) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.diagram = diagram;
    }

    public PlacementConstraint() {
    }

    public Rectangle getUpdatedBounds(IFigure target) {
        int tmpwidth = this.getWidth();
        int tmpheight = this.getHeight();
        if (tmpwidth == -1 || tmpheight == -1) {
            Dimension preferredSize = target.getPreferredSize(tmpwidth, tmpheight);
            if (tmpwidth == -1) {
                tmpwidth = preferredSize.width;
            }
            if (tmpheight == -1) {
                tmpheight = preferredSize.height;
            }
        }
        return new Rectangle(this.getX(), this.getY(), tmpwidth, tmpheight);
    }

    public boolean isExternal(IDiagramWriter out) {
        return false;
    }

    public void read(IDiagramReader in) {
        this.x = (Integer)in.readProperty("x");
        this.y = (Integer)in.readProperty("y");
        this.width = (Integer)in.readProperty("width");
        this.height = (Integer)in.readProperty("height");
        this.diagram = (GmSequenceDiagram)in.getRoot();
    }

    public void relocate(IFigure target) {
        target.setBounds(this.getUpdatedBounds(target));
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void write(IDiagramWriter out) {
        out.writeProperty("x", (Object)this.x);
        out.writeProperty("y", (Object)this.y);
        out.writeProperty("width", (Object)this.width);
        out.writeProperty("height", (Object)this.height);
    }

    protected int getHeight() {
        return this.height;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getX() {
        return this.x;
    }

    protected int getY() {
        return this.y;
    }

    protected <E extends IElement> E resolveRef(ObRef ref) {
        return (E)this.diagram.getModelManager().resolveRef(ref);
    }

    public int getMajorVersion() {
        return 0;
    }
}

