/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.PlacementConstraint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class SequenceDiagramLayout
extends AbstractLayout {
    private Map<IFigure, PlacementConstraint> selfLocatingConstraints = new HashMap();
    private Map<IFigure, Rectangle> simpleConstraints = new HashMap();

    public Object getConstraint(IFigure child) {
        return this.selfLocatingConstraints.get(child) != null ? this.selfLocatingConstraints.get(child) : this.simpleConstraints.get(child);
    }

    public void layout(IFigure parent) {
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            PlacementConstraint locator = this.getLocator(child);
            if (locator != null) {
                locator.relocate(child);
            } else {
                Rectangle simpleConstraint = this.getSimpleConstraint(child);
                if (simpleConstraint != null) {
                    if (simpleConstraint.width == -1 || simpleConstraint.height == -1) {
                        simpleConstraint = simpleConstraint.getCopy();
                        Dimension childPreferredSize = child.getPreferredSize(simpleConstraint.width, simpleConstraint.height);
                        if (simpleConstraint.width == -1) {
                            simpleConstraint.width = childPreferredSize.width;
                        }
                        if (simpleConstraint.height == -1) {
                            simpleConstraint.height = childPreferredSize.height;
                        }
                    }
                    child.setBounds(simpleConstraint);
                }
            }
            ++i;
        }
    }

    public void remove(IFigure child) {
        this.selfLocatingConstraints.remove(child);
        this.simpleConstraints.remove(child);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        super.setConstraint(figure, constraint);
        if (constraint != null && constraint instanceof PlacementConstraint) {
            this.selfLocatingConstraints.put(figure, (PlacementConstraint)constraint);
        } else if (constraint != null && constraint instanceof Rectangle) {
            this.simpleConstraints.put(figure, (Rectangle)constraint);
        }
    }

    protected Dimension calculatePreferredSize(IFigure parent, int wHint, int hHint) {
        List children = parent.getChildren();
        Dimension d = new Dimension();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getPreferredSize());
            ++i;
        }
        return d;
    }

    private PlacementConstraint getLocator(IFigure child) {
        return (PlacementConstraint)this.selfLocatingConstraints.get(child);
    }

    private Rectangle getSimpleConstraint(IFigure child) {
        return (Rectangle)this.simpleConstraints.get(child);
    }
}

