/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ICombinedFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IGate;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionUse;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.combinedfragment.CreateCombinedFragmentCommand;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.gate.CreateGateCommand;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.interactionuse.CreateInteractionUseCommand;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.lifeline.GmLifeline;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.CreatePartDecompositionCommand;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.IPlacementConstraintProvider;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.PlacementConstraint;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.commands.NodeChangeLayoutCommand;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultNodeResizableEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.policies.DiagramEditLayoutPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class SequenceDiagramLayoutPolicy
extends DiagramEditLayoutPolicy {
    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (((GmModel)child.getModel()).getRelatedIElement() instanceof IInteractionUse) {
            return this.createChangeConstraintCommandForInteractionUse(request, (GraphicalEditPart)child, constraint);
        }
        if (((GmModel)child.getModel()).getRelatedIElement() instanceof ICombinedFragment) {
            return this.createChangeConstraintCommandForCombinedFragment(request, (GraphicalEditPart)child, constraint);
        }
        if (((GmModel)child.getModel()).getRelatedIElement() instanceof ILifeline) {
            return this.createChangeConstraintCommandForLifeline(child, constraint);
        }
        if (((GmModel)child.getModel()).getRelatedIElement() instanceof IGate) {
            return this.createChangeConstraintCommandForGate((GraphicalEditPart)child, constraint);
        }
        return super.createChangeConstraintCommand(request, child, constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child.getModel() instanceof GmLifeline) {
            DefaultNodeResizableEditPolicy policy = new DefaultNodeResizableEditPolicy();
            policy.setResizeDirections(24);
            return policy;
        }
        return super.createChildEditPolicy(child);
    }

    protected Command getCreateCommand(CreateRequest request) {
        ModelioCreationContext ctx = (ModelioCreationContext)request.getNewObject();
        if ("InteractionUse".equals(ctx.getMetaclass())) {
            ArrayList coveredLifelines = new ArrayList();
            Rectangle requestRect = (Rectangle)this.getConstraintFor(request);
            this.getCoveredLifelines(requestRect, coveredLifelines);
            return new CreateInteractionUseCommand((GmSequenceDiagram)this.getHostCompositeNode(), ctx, requestRect, coveredLifelines);
        }
        if ("CombinedFragment".equals(ctx.getMetaclass())) {
            ArrayList coveredLifelines = new ArrayList();
            Rectangle requestRect = (Rectangle)this.getConstraintFor(request);
            this.getCoveredLifelines(requestRect, coveredLifelines);
            return new CreateCombinedFragmentCommand((GmSequenceDiagram)this.getHostCompositeNode(), ctx, requestRect, coveredLifelines);
        }
        if ("Gate".equals(ctx.getMetaclass())) {
            Rectangle requestRect = (Rectangle)this.getConstraintFor(request);
            return new CreateGateCommand((IInteraction)this.getHostElement(), this.getHostCompositeNode(), ctx, (Object)requestRect, requestRect.getLocation().y);
        }
        if ("PartDecomposition".equals(ctx.getMetaclass())) {
            Rectangle requestRect = (Rectangle)this.getConstraintFor(request);
            return new CreatePartDecompositionCommand((IInteraction)this.getHostElement(), this.getHostCompositeNode(), ctx, (Object)requestRect);
        }
        return super.getCreateCommand(request);
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        Object constraint = fig.getParent().getLayoutManager().getConstraint(fig);
        if (constraint instanceof PlacementConstraint) {
            return ((PlacementConstraint)constraint).getUpdatedBounds(child.getFigure());
        }
        if (constraint instanceof Rectangle) {
            return (Rectangle)constraint;
        }
        return null;
    }

    protected Point getLayoutOrigin() {
        return new Point();
    }

    private Command createChangeConstraintCommandForGate(GraphicalEditPart childEditPart, Object constraint) {
        Rectangle rect = (Rectangle)constraint;
        PlacementConstraint placementConstraint = ((IPlacementConstraintProvider)childEditPart).createPlacementConstraint((GmModel)childEditPart.getModel(), rect.x, rect.y, rect.width, rect.height);
        NodeChangeLayoutCommand command = new NodeChangeLayoutCommand();
        command.setModel(childEditPart.getModel());
        command.setConstraint((Object)placementConstraint);
        return command;
    }

    private Command createChangeConstraintCommandForInteractionUse(ChangeBoundsRequest request, GraphicalEditPart childEditPart, Object constraint) {
        Rectangle rect = (Rectangle)constraint;
        PlacementConstraint placementConstraint = ((IPlacementConstraintProvider)childEditPart).createPlacementConstraint((GmModel)childEditPart.getModel(), rect.x, rect.y, rect.width, rect.height);
        NodeChangeLayoutCommand command = new NodeChangeLayoutCommand();
        command.setModel(childEditPart.getModel());
        command.setConstraint((Object)placementConstraint);
        return command;
    }

    private Command createChangeConstraintCommandForLifeline(EditPart childEditPart, Object constraint) {
        Rectangle rect = (Rectangle)constraint;
        PlacementConstraint placementConstraint = ((IPlacementConstraintProvider)childEditPart).createPlacementConstraint((GmModel)childEditPart.getModel(), rect.x, rect.y, rect.width, rect.height);
        NodeChangeLayoutCommand command = new NodeChangeLayoutCommand();
        command.setModel(childEditPart.getModel());
        command.setConstraint((Object)placementConstraint);
        return command;
    }

    private void getAllChildren(EditPart editPart, Set<GraphicalEditPart> allChildren) {
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            allChildren.add(child);
            this.getAllChildren((EditPart)child, allChildren);
            ++i;
        }
    }

    private void getCoveredLifelines(Rectangle requestRect, List<GmLifeline> coveredLifelines) {
        HashSet allChildren = new HashSet();
        this.getAllChildren(this.getHost(), allChildren);
        for (GraphicalEditPart childEditPart : allChildren) {
            if (!(childEditPart.getModel() instanceof GmLifeline) || !requestRect.intersects(childEditPart.getFigure().getBounds())) continue;
            coveredLifelines.add((GmLifeline)childEditPart.getModel());
        }
    }

    private Command createChangeConstraintCommandForCombinedFragment(ChangeBoundsRequest request, GraphicalEditPart childEditPart, Object constraint) {
        Rectangle rect = (Rectangle)constraint;
        PlacementConstraint placementConstraint = ((IPlacementConstraintProvider)childEditPart).createPlacementConstraint((GmModel)childEditPart.getModel(), rect.x, rect.y, rect.width, rect.height);
        NodeChangeLayoutCommand command = new NodeChangeLayoutCommand();
        command.setModel(childEditPart.getModel());
        command.setConstraint((Object)placementConstraint);
        return command;
    }

    protected Dimension getMinimumSizeFor(GraphicalEditPart child) {
        return new Dimension(8, 0);
    }
}

