/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.api.model.diagrams.ISequenceDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.SmartCreateInteractionUseCommand;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.SmartCreateLifelineCommand;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class SequenceElementDropEditPolicy
extends DiagramElementDropEditPolicy {
    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        GmCompositeNode gmModel = (GmCompositeNode)this.getHost().getModel();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement droppedElement = iElementArray[n2];
            if (!(gmModel.canUnmask(droppedElement) || this.isSmartLifelineNodeTarget(droppedElement, request) || droppedElement instanceof IInteraction && request.isSmart())) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            if (this.isSmartLifelineNodeTarget(toUnmask, request)) {
                command.add(this.getSmartObjectNodeDropCommand(dropLocation, toUnmask));
            } else if (toUnmask instanceof IInteraction && request.isSmart()) {
                command.add(this.getSmartInteractionDropCommand(dropLocation, toUnmask));
            } else if (toUnmask != null) {
                this.createSubRequest(request, command, dropLocation, toUnmask);
            }
            dropLocation = dropLocation.getTranslated(20, 20);
            ++n2;
        }
        return command.unwrap();
    }

    private Command getSmartObjectNodeDropCommand(Point dropLocation, IElement toUnmask) {
        GmModel gmModel = (GmModel)this.getHost().getModel();
        ISequenceDiagram owner = (ISequenceDiagram)gmModel.getRelatedIElement();
        IModelElement origin = owner.getOrigin();
        if (origin instanceof IInteraction) {
            return new SmartCreateLifelineCommand(dropLocation, toUnmask, this.getHost(), (IElement)origin);
        }
        return null;
    }

    private boolean isSmartLifelineNodeTarget(IElement element, ModelElementDropRequest request) {
        if (!request.isSmart()) {
            return false;
        }
        return element instanceof IAssociationEnd || element instanceof IAttribute || element instanceof IInstance && !(element instanceof IPort) || element instanceof IGeneralClass;
    }

    private Command getSmartInteractionDropCommand(Point dropLocation, IElement toUnmask) {
        GmSequenceDiagram diagramModel = (GmSequenceDiagram)this.getHost().getModel();
        ISequenceDiagram owner = (ISequenceDiagram)diagramModel.getRelatedIElement();
        IInteraction origin = (IInteraction)owner.getOrigin();
        return new SmartCreateInteractionUseCommand(dropLocation, (IInteraction)toUnmask, this.getHost(), origin);
    }

    private void createSubRequest(ModelElementDropRequest request, CompoundCommand command, Point dropLocation, IElement toUnmask) {
        ModelElementDropRequest subReq = new ModelElementDropRequest();
        subReq.setDroppedElements(new IElement[]{toUnmask});
        subReq.setExtendedData(request.getExtendedData());
        subReq.setLocation(dropLocation);
        subReq.isSmart(request.isSmart());
        command.add(super.getDropCommand(subReq));
    }
}

