/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionUse;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class SmartCreateInteractionUseCommand
extends Command {
    private IInteraction parentElement;
    private IInteraction toUnmask;
    private Point location;
    private EditPart parentEditPart;
    private static final int DEFAULT_SIZE = 50;

    public SmartCreateInteractionUseCommand(Point dropLocation, IInteraction toUnmask, EditPart parentEditPart, IInteraction parentElement) {
        this.location = dropLocation;
        this.toUnmask = toUnmask;
        this.parentEditPart = parentEditPart;
        this.parentElement = parentElement;
    }

    public boolean canExecute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }

    public void execute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IInteractionUse interactionUse = factory.createInteractionUse(this.toUnmask);
        interactionUse.setLineNumber(this.location.y);
        interactionUse.setEndLineNumber(this.location.y + 50);
        this.parentElement.addFragment((IInteractionFragment)interactionUse);
        this.unmaskElement((IElement)interactionUse);
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.location);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.parentEditPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }
}

