/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.UnmaskHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class SmartCreateLifelineCommand
extends Command {
    private IElement parentElement;
    private IElement toUnmask;
    private Point location;
    private EditPart parentEditPart;

    public SmartCreateLifelineCommand(Point dropLocation, IElement toUnmask, EditPart parentEditPart, IElement parentElement) {
        this.location = dropLocation;
        this.toUnmask = toUnmask;
        this.parentEditPart = parentEditPart;
        this.parentElement = parentElement;
    }

    public boolean canExecute() {
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)gmDiagram)) {
            return false;
        }
        return this.parentElement != null && this.parentElement.isValid() && this.parentElement.getElementStatus().isModifiable();
    }

    public void execute() {
        IInstance instanceNode;
        GmModel gmModel = (GmModel)this.parentEditPart.getModel();
        GmAbstractDiagram gmDiagram = gmModel.getDiagram();
        IModelFactory factory = gmDiagram.getModelFactory();
        IInteraction interaction = (IInteraction)this.parentElement;
        ILifeline lifelineNode = factory.createLifeline("", interaction);
        this.unmaskElement((IElement)lifelineNode);
        if (this.toUnmask instanceof IInstance) {
            instanceNode = (IInstance)this.toUnmask;
        } else {
            instanceNode = this.createInstance(factory, interaction);
            Collection ports = null;
            if (this.toUnmask instanceof IInstance) {
                ((IBindableInstance)instanceNode).setRepresentedFeature((IModelElement)((IInstance)this.toUnmask));
            } else if (this.toUnmask instanceof IAttribute) {
                ((IBindableInstance)instanceNode).setRepresentedFeature((IModelElement)((IAttribute)this.toUnmask));
                instanceNode.setBase((INameSpace)((IAttribute)this.toUnmask).getType());
            } else if (this.toUnmask instanceof IAssociationEnd) {
                ((IBindableInstance)instanceNode).setRepresentedFeature((IModelElement)((IAssociationEnd)this.toUnmask));
            } else if (this.toUnmask instanceof IGeneralClass) {
                instanceNode.setBase((INameSpace)this.toUnmask);
                ports = this.createPorts((IBindableInstance)instanceNode);
            } else if (this.toUnmask instanceof IModelElement) {
                ((IBindableInstance)instanceNode).setRepresentedFeature((IModelElement)this.toUnmask);
            }
            if (ports != null) {
                this.location.translate(100, 10);
                Command cmd = UnmaskHelper.getUnmaskCommand((EditPartViewer)this.parentEditPart.getViewer(), ports, (Point)this.location);
                if (cmd != null && cmd.canExecute()) {
                    cmd.execute();
                }
            }
        }
        lifelineNode.setRepresented(instanceNode);
        lifelineNode.setName(instanceNode.getName());
    }

    private IBindableInstance createInstance(IModelFactory factory, IInteraction interaction) {
        ICollaboration localsCollaboration = this.getLocalsCollaboration(interaction);
        if (localsCollaboration == null) {
            localsCollaboration = this.createLocalsCollaboration(factory, interaction);
        }
        IBindableInstance instanceNode = factory.createBindableInstance();
        localsCollaboration.addDeclared((IInstance)instanceNode);
        DefaultNameFactory.setDefaultNameUsingBaseName((IModelElement)instanceNode, (String)"r");
        return instanceNode;
    }

    private ICollaboration createLocalsCollaboration(IModelFactory factory, IInteraction interaction) {
        ICollaboration localsCollaboration = factory.createCollaboration();
        localsCollaboration.setName("locals");
        interaction.addOwnedCollaboration(localsCollaboration);
        return localsCollaboration;
    }

    private ICollaboration getLocalsCollaboration(IInteraction interaction) {
        for (ICollaboration collaboration : interaction.getOwnedCollaboration()) {
            if (!collaboration.getName().equals("locals")) continue;
            return collaboration;
        }
        return null;
    }

    private Collection<IPort> createPorts(IBindableInstance part) {
        IClassifier type = (IClassifier)part.getBase();
        ArrayList<IPort> ret = new ArrayList<IPort>(type.cardInternalStructure());
        for (IBindableInstance typePart : type.getInternalStructure()) {
            if (!(typePart instanceof IPort)) continue;
            IPort partPort = (IPort)ModelServices.clone((IElement)typePart);
            part.addPart((IBindableInstance)partPort);
            partPort.setRepresentedFeature((IModelElement)typePart);
            ret.add(partPort);
        }
        return ret;
    }

    private void unmaskElement(IElement el) {
        ModelioCreationContext gmCreationContext = new ModelioCreationContext(el);
        CreateRequest creationRequest = new CreateRequest();
        creationRequest.setLocation(this.location);
        creationRequest.setSize(new Dimension(-1, -1));
        creationRequest.setFactory((CreationFactory)gmCreationContext);
        Command cmd = this.parentEditPart.getTargetEditPart((Request)creationRequest).getCommand((Request)creationRequest);
        if (cmd != null && cmd.canExecute()) {
            cmd.execute();
        }
    }
}

