/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.stateinvariant;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateInvariant;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;

public class CreateStateInvariantCommand
extends Command {
    private Rectangle initialLayoutData;
    private GmCompositeNode parentNode;

    public CreateStateInvariantCommand(GmCompositeNode parentNode, Rectangle initialLayoutData) {
        this.initialLayoutData = initialLayoutData;
        this.parentNode = parentNode;
    }

    public void execute() {
        IElement parentElement = this.parentNode.getRelatedIElement();
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IModelFactory modelFactory = diagram.getModelFactory();
        IElementInitializer elementInitializer = diagram.getElementInitializer();
        IInteraction interaction = null;
        ILifeline lifeline = null;
        if (parentElement instanceof ILifeline) {
            lifeline = (ILifeline)parentElement;
            interaction = lifeline.getOwner();
        }
        IStateInvariant newStateInvariant = modelFactory.createStateInvariant();
        newStateInvariant.setEnclosingInteraction(interaction);
        newStateInvariant.addCovered(lifeline);
        elementInitializer.initialize((IElement)newStateInvariant);
        newStateInvariant.setLineNumber(this.initialLayoutData.y);
        newStateInvariant.setEndLineNumber(this.initialLayoutData.bottom());
        diagram.unmask(this.parentNode, (IElement)newStateInvariant, (Object)this.initialLayoutData);
    }
}

