/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.stateinvariant;

import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateInvariant;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.stateinvariant.GmStateInvariant;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.gef.commands.Command;

public class ReparentStateInvariantCommand
extends Command {
    private GmCompositeNode newParentNode;
    private GmStateInvariant reparentedChild;
    private int finishTime;
    private int startTime;

    public ReparentStateInvariantCommand(GmCompositeNode newParent, GmStateInvariant reparentedChild, int startTime, int finishTime) {
        this.newParentNode = newParent;
        this.reparentedChild = reparentedChild;
        this.startTime = startTime;
        this.finishTime = finishTime;
    }

    public boolean canExecute() {
        IStateInvariant childElement = this.reparentedChild.getRelatedIElement();
        if (childElement == null || !childElement.getElementStatus().isModifiable()) {
            return false;
        }
        IElement oldParent = this.reparentedChild.getParent().getRelatedIElement();
        IElement newParent = this.newParentNode.getRelatedIElement();
        if (newParent == null) {
            return false;
        }
        boolean sameParentInObModel = newParent.equals((Object)oldParent);
        return sameParentInObModel || newParent.getElementStatus().isModifiable() && CreationExpertRegistry.getExpert(newParent.getClass()).canOwn(newParent, (IElement)childElement, CompositionServices.getCompositionParentDep((IElement)childElement));
    }

    public void execute() {
        IStateInvariant childElement = this.reparentedChild.getRelatedIElement();
        IElement oldParentElement = this.reparentedChild.getParent().getRelatedIElement();
        String oldParentDep = "CoveredBy";
        IElement newParentElement = this.newParentNode.getRelatedIElement();
        boolean sameParentInObModel = newParentElement.equals((Object)childElement.getCompositionOwner());
        if (!sameParentInObModel) {
            Meta meta = new Meta(oldParentElement);
            meta.removeFromDependency(oldParentDep, (IElement)childElement);
        }
        GmCompositeNode oldParent = (GmCompositeNode)this.reparentedChild.getParent();
        oldParent.removeChild((GmNodeModel)this.reparentedChild);
        if (!sameParentInObModel) {
            Meta meta = new Meta(newParentElement);
            try {
                meta.appendToDependency(oldParentDep, (IElement)childElement);
            }
            catch (InvalidModelManipulationException e) {
                String newParentDep = CompositionExpert.getDefaultCompositionDep((IElement)newParentElement, (IElement)childElement);
                meta.appendToDependency(newParentDep, (IElement)childElement);
            }
        }
        this.newParentNode.addChild((GmNodeModel)this.reparentedChild);
        IStateInvariant stateInvariant = this.reparentedChild.getRelatedIElement();
        stateInvariant.setLineNumber(this.startTime);
        stateInvariant.setEndLineNumber(this.finishTime);
    }
}

