/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.editor.sequence.elements.stateinvariant;

import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateInvariant;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.GmSequenceDiagram;
import com.modeliosoft.modelio.diagram.editor.sequence.elements.sequencediagram.PlacementConstraint;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;

public class StateInvariantPlacementConstraint
extends PlacementConstraint {
    private IStateInvariant stateInvariant;
    private static final int MINIMUM_WIDTH = 50;
    private static final int MAJOR_VERSION = 0;

    public StateInvariantPlacementConstraint(IStateInvariant stateInvariant, int x, int y, int width, int height, GmSequenceDiagram diagram) {
        super(x, y, width, height, diagram);
        this.stateInvariant = stateInvariant;
        if (this.stateInvariant.isValid()) {
            this.setY(this.stateInvariant.getLineNumber());
            this.setHeight(this.stateInvariant.getEndLineNumber() - this.getY());
        }
    }

    public StateInvariantPlacementConstraint() {
    }

    public Rectangle getUpdatedBounds(IFigure target) {
        Rectangle rect = super.getUpdatedBounds(target);
        if (rect.width < 50) {
            rect.width = 50;
        }
        rect.translate(-rect.width / 2, 0);
        return rect;
    }

    public void read(IDiagramReader reader) {
        super.read(reader);
        this.stateInvariant = (IStateInvariant)this.resolveRef((ObRef)reader.readProperty("StateInvariant"));
        if (this.stateInvariant.isValid()) {
            this.setY(this.stateInvariant.getLineNumber());
            this.setHeight(this.stateInvariant.getEndLineNumber() - this.getY());
        }
    }

    public void write(IDiagramWriter writer) {
        super.write(writer);
        writer.writeProperty("StateInvariant", new ObRef((IElement)this.stateInvariant));
    }

    protected int getHeight() {
        if (this.stateInvariant.isValid()) {
            this.setHeight(this.stateInvariant.getEndLineNumber() - this.getY());
        }
        return super.getHeight();
    }

    protected int getY() {
        if (this.stateInvariant.isValid()) {
            this.setY(this.stateInvariant.getLineNumber());
        }
        return super.getY();
    }

    public int getMajorVersion() {
        return 0;
    }
}

