/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.generation;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.generation.PartialExportMap;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.gui.ProgressBarComposite;
import com.modeliosoft.modelio.xmi.model.objing.IOElement;
import com.modeliosoft.modelio.xmi.util.CompositionOwnerVisitor;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.NotFoundException;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ScopeChecker;
import org.eclipse.uml2.uml.Element;

public class ExportModel {
    private ProgressBarComposite progressBar = null;
    private CompositionOwnerVisitor ownerVisitor = new CompositionOwnerVisitor();
    private ScopeChecker scopeChecker = new ScopeChecker((IElement)GenerationProperties.getInstance().getSelectedPackage(), this.ownerVisitor);

    public void export(IOElement ioelem) {
        block6: {
            try {
                Element ecoreElt;
                if (!this.scopeChecker.contains(ioelem.getObjingElement()) || (ecoreElt = TotalExportMap.getInstance().get(ioelem.getObjingID())) != null && !this.isSuperCall(ioelem)) break block6;
                if (ecoreElt == null) {
                    ecoreElt = PartialExportMap.getInstance().remove(ioelem.getObjingID());
                } else {
                    PartialExportMap.getInstance().remove(ioelem.getObjingID());
                    TotalExportMap.getInstance().remove(ioelem.getObjingID());
                }
                if (ecoreElt == null) {
                    ecoreElt = this.createElement(ioelem);
                }
                if (ecoreElt != null) {
                    PartialExportMap.getInstance().put(ioelem.getObjingID(), ecoreElt);
                    this.finishElementCreation(ecoreElt, ioelem);
                    PartialExportMap.getInstance().remove(ioelem.getObjingID());
                    TotalExportMap.getInstance().put(ioelem.getObjingID(), ecoreElt);
                    break block6;
                }
                throw new NotFoundException("Element of type " + ioelem.getObjingElement().getClass().getSimpleName() + " has no mapping to EMF-UML2.");
            }
            catch (NotFoundException e) {
                LOG.warning((String)"org.modelio.xmi.internal", (String)e.getLocalizedMessage());
            }
        }
    }

    private boolean isSuperCall(IOElement ioelem) {
        IElement objingElt = ioelem.getObjingElement();
        String mapperName = ioelem.getClass().getSimpleName();
        String eltClassName = objingElt.getClass().getSimpleName();
        return !(mapperName = mapperName.substring(1)).equals(eltClassName = eltClassName.substring(2));
    }

    public ExportModel(ProgressBarComposite progressBar) {
        this.progressBar = progressBar;
        GenerationProperties.getInstance().setScopeChecker(this.scopeChecker);
    }

    public ExportModel() {
        this.progressBar = null;
    }

    private Element createElement(IOElement ioelem) {
        return ioelem.createEcoreElt();
    }

    private void finishElementCreation(Element ecoreElt, IOElement ioelem) {
        if (GenerationProperties.getInstance().isRoundtripEnabled() && ioelem.getObjingElement().getElementStatus().isRamcObject()) {
            ObjingEAnnotation.addObjingID((Element)ecoreElt, (String)ioelem.getObjingElement().getIdentifier());
        }
        ioelem.attach(ecoreElt, this.ownerVisitor);
        ioelem.setProperties(ecoreElt);
        if (this.progressBar != null) {
            this.progressBar.addElement();
            if (ioelem.getObjingElement() instanceof INameSpace) {
                this.progressBar.addValue();
            }
        }
    }
}

