/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.generation;

import com.modeliosoft.modelio.api.model.analyst.IRequirement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.utils.IMetamodelVisitor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.api.VersionExport;
import com.modeliosoft.modelio.xmi.api.XMIExtension;
import com.modeliosoft.modelio.xmi.generation.GenericMetamodelVisitor;
import com.modeliosoft.modelio.xmi.generation.IParseModelBehavior;
import com.modeliosoft.modelio.xmi.generation.PartialExportMap;
import com.modeliosoft.modelio.xmi.generation.ProfileExportVisitorImpl;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.generation.XMIExportBehavior;
import com.modeliosoft.modelio.xmi.gui.ProgressBarComposite;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportProfile;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.CompositionOwnerVisitor;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.PrimitiveTypeMapper;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import com.modeliosoft.modelio.xmi.util.ScopeChecker;
import com.modeliosoft.modelio.xmi.util.TaggedValueUtils;
import com.modeliosoft.modelio.xmi.util.XMIFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.resource.UMLResourceFactoryImpl;
import org.eclipse.uml2.uml.resource.UMLResource;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ExportServices {
    private static final String version = "2.2";
    private final Shell _shell;

    public Resource createResource(String resourcePath) {
        File file = new File(resourcePath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
        }
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        resourceSet2.getPackageRegistry().put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", UMLResource.Factory.INSTANCE);
        Map uriMap = resourceSet2.getURIConverter().getURIMap();
        URI uri = URI.createURI((String)ResourceLoader.getInstance().getUMLRessource());
        uriMap.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri.appendSegment("libraries").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri.appendSegment("metamodels").appendSegment(""));
        uriMap.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new UMLResourceFactoryImpl());
        URI fileURI2 = URI.createFileURI((String)file.getAbsolutePath());
        Resource resource2 = resourceSet2.createResource(fileURI2);
        return resource2;
    }

    private void applyProfile() {
        GenerationProperties genProp = GenerationProperties.getInstance();
        Model model = genProp.getEcoreModel();
        for (Profile profile : genProp.getExportedProfiles()) {
            try {
                model.applyProfile(profile);
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
        }
        if (genProp.isSysMLApplied()) {
            try {
                model.applyProfile(genProp.getSysMLProfile());
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
            this.applySysML();
        }
        for (IModelElement element : genProp.getStereotypesExported()) {
            Element ecoreElement = genProp.getMappedElement((IElement)element);
            if (ecoreElement == null) continue;
            this.exportStereotype(element, ecoreElement);
            if (genProp.isRoundtripEnabled()) {
                TaggedValueUtils.setValueEAnnotation((IModelElement)element, (Element)ecoreElement);
                continue;
            }
            TaggedValueUtils.setValue((IModelElement)element, (Element)ecoreElement);
        }
        genProp.cleanStereotypesExported();
    }

    public ExportServices(Shell theShell) {
        this._shell = theShell;
    }

    public boolean createEcoreModel(Resource resource, ProgressBarComposite progressBar) {
        boolean error = false;
        if (resource != null) {
            GenerationProperties genProp = GenerationProperties.getInstance();
            PartialExportMap partialMap = PartialExportMap.getInstance();
            partialMap.clear();
            TotalExportMap totalMap = TotalExportMap.getInstance();
            totalMap.clear();
            IPackage selectedPkg = genProp.getSelectedPackage();
            Model ecoreModel = UMLFactory.eINSTANCE.createModel();
            ObjingEAnnotation.setExporterVersion((Element)ecoreModel, (String)version);
            ObjingEAnnotation.setRoundTrip((Element)ecoreModel, (boolean)genProp.isRoundtripEnabled());
            ecoreModel.setName(selectedPkg.getName());
            genProp.setEcoreModel(ecoreModel);
            ArrayList<IPackage> exportScopeElts = new ArrayList<IPackage>();
            exportScopeElts.add(selectedPkg);
            partialMap.put(selectedPkg.getIdentifier(), (Element)ecoreModel);
            genProp.setExportScopeElts(exportScopeElts);
            XMIExportBehavior exportBehavior = new XMIExportBehavior(progressBar);
            GenericMetamodelVisitor visitObjingModel = new GenericMetamodelVisitor((IParseModelBehavior)exportBehavior);
            genProp.setObjingVisitor(visitObjingModel);
            boolean ecoreRootNull = true;
            for (IModelTree iModelTree : exportScopeElts) {
                iModelTree.accept((IMetamodelVisitor)visitObjingModel);
                Namespace ecoreRoot = (Namespace)genProp.getMappedElement((IElement)iModelTree);
                if (ecoreRoot == null) continue;
                ecoreRootNull = false;
                if (!ecoreRoot.equals(ecoreModel)) {
                    ecoreModel.getPackagedElements().add((Object)((PackageableElement)ecoreRoot));
                }
                for (PrimitiveType primitive : PrimitiveTypeMapper.getPredifinedTypeList()) {
                    ecoreModel.getPackagedElements().add((Object)primitive);
                }
            }
            if (!ecoreRootNull) {
                if (progressBar != null) {
                    progressBar.setLabel(XMI.I18N.getString("progressBar.content.export.XMIFileSave"));
                }
                resource.getContents().add((Object)ecoreModel);
                this.profileDefinition();
                this.profileExport(progressBar);
                this.applyProfile();
                partialMap.clear();
                totalMap.clear();
                if (progressBar != null) {
                    progressBar.setLabel(XMI.I18N.getString("progressBar.content.export.XMIFileSave"));
                }
                if (error = this.saveRessource(resource)) {
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_failed"));
                }
            } else {
                Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_failed.root_null"));
            }
            genProp.supressProfile();
            if (genProp.isSysMLApplied()) {
                genProp.supressSysMLProfile();
            }
        }
        return error;
    }

    private void profileExport(ProgressBarComposite progressBar) {
        EObject eObject;
        TreeIterator allContents;
        Resource resourceProfile;
        String profilePath;
        String extension;
        for (Profile profile : GenerationProperties.getInstance().getExportedProfiles()) {
            if (profile.getOwner() != null) continue;
            if (progressBar != null) {
                progressBar.setLabel(XMI.I18N.getMessage("progressBar.content.export.XMIProfileSave", new String[]{profile.getName()}));
            }
            extension = null;
            extension = GenerationProperties.getInstance().getFileExtension().equals((Object)XMIExtension.XMI) ? ".xmi" : ".uml";
            profilePath = String.valueOf(GenerationProperties.getInstance().getFileDirectory()) + File.separator + profile.getName() + ".profile" + extension;
            resourceProfile = this.createResource(profilePath);
            resourceProfile.getContents().add((Object)profile);
            allContents = UMLUtil.getAllContents((EObject)profile, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                resourceProfile.getContents().addAll((Collection)((Element)eObject).getStereotypeApplications());
            }
            try {
                resourceProfile.save(null);
                if (GenerationProperties.getInstance().getExportVersion().equals((Object)VersionExport.EMF300)) continue;
                XMIFileUtils.changeToUML((String)resourceProfile.getURI().toFileString());
            }
            catch (IOException ioe) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)ioe);
            }
        }
        if (GenerationProperties.getInstance().isSysMLApplied()) {
            Profile profile;
            profile = GenerationProperties.getInstance().getSysMLProfile();
            String profileName = profile.getName();
            if (progressBar != null) {
                progressBar.setLabel(XMI.I18N.getMessage("progressBar.content.export.XMIProfileSave", new String[]{profileName}));
            }
            extension = null;
            extension = GenerationProperties.getInstance().getFileExtension().equals((Object)XMIExtension.XMI) ? ".xmi" : ".uml";
            profilePath = String.valueOf(GenerationProperties.getInstance().getFileDirectory()) + File.separator + profileName + ".profile" + extension;
            resourceProfile = this.createResource(profilePath);
            resourceProfile.getContents().add((Object)profile);
            allContents = UMLUtil.getAllContents((EObject)profile, (boolean)true, (boolean)false);
            while (allContents.hasNext()) {
                eObject = (EObject)allContents.next();
                if (!(eObject instanceof Element)) continue;
                resourceProfile.getContents().addAll((Collection)((Element)eObject).getStereotypeApplications());
            }
            try {
                resourceProfile.save(null);
                if (!GenerationProperties.getInstance().getExportVersion().equals((Object)VersionExport.EMF300)) {
                    XMIFileUtils.changeToUML((String)resourceProfile.getURI().toFileString());
                }
            }
            catch (IOException ioe) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)ioe);
            }
        }
    }

    public Model createEcoreModel(IPackage selectedPkg, ProgressBarComposite progressBar) {
        GenerationProperties genProp = GenerationProperties.getInstance();
        PartialExportMap partialMap = PartialExportMap.getInstance();
        TotalExportMap totalMap = TotalExportMap.getInstance();
        partialMap.clear();
        totalMap.clear();
        Model ecoreModel = UMLFactory.eINSTANCE.createModel();
        ObjingEAnnotation.setExporterVersion((Element)ecoreModel, (String)version);
        ObjingEAnnotation.setRoundTrip((Element)ecoreModel, (boolean)genProp.isRoundtripEnabled());
        ArrayList<IPackage> exportScopeElts = new ArrayList<IPackage>();
        exportScopeElts.add(selectedPkg);
        genProp.setExportScopeElts(exportScopeElts);
        ecoreModel.setName(selectedPkg.getName());
        partialMap.put(selectedPkg.getIdentifier(), (Element)ecoreModel);
        genProp.setEcoreModel(ecoreModel);
        XMIExportBehavior exportBehavior = new XMIExportBehavior(progressBar);
        GenericMetamodelVisitor visitObjingModel = new GenericMetamodelVisitor((IParseModelBehavior)exportBehavior);
        genProp.setObjingVisitor(visitObjingModel);
        boolean ecoreRootNull = true;
        for (IModelTree iModelTree : exportScopeElts) {
            iModelTree.accept((IMetamodelVisitor)visitObjingModel);
            Namespace ecoreRoot = (Namespace)genProp.getMappedElement((IElement)iModelTree);
            if (ecoreRoot == null) continue;
            ecoreRootNull = false;
            if (ecoreRoot.equals(ecoreModel)) continue;
            ecoreModel.getPackagedElements().add((Object)((PackageableElement)ecoreRoot));
        }
        if (ecoreRootNull) {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_failed.root_null"));
        }
        return ecoreModel;
    }

    public int countModelTrees(IModelTree theElement) {
        int sum = 1;
        ObList ownedElts = theElement.getOwnedElement();
        for (IModelTree elt : ownedElts) {
            sum += this.countModelTrees(elt);
        }
        return sum;
    }

    public boolean createEcoreProfile(Resource resource, ProgressBarComposite progressBar) {
        boolean error = false;
        if (resource != null) {
            GenerationProperties genProp = GenerationProperties.getInstance();
            IProfile rootProfile = (IProfile)genProp.getSelectedPackage();
            PartialExportMap partialMap = PartialExportMap.getInstance();
            TotalExportMap totalMap = TotalExportMap.getInstance();
            partialMap.clear();
            totalMap.clear();
            Profile ecoreProfile = ProfileUtils.createEcoreProfile((IProfile)rootProfile);
            TotalExportMap.getInstance().put(rootProfile.getIdentifier(), (Element)ecoreProfile);
            CompositionOwnerVisitor ownerVisitor = new CompositionOwnerVisitor();
            ScopeChecker scopeChecker = new ScopeChecker((IElement)GenerationProperties.getInstance().getSelectedPackage(), ownerVisitor);
            GenerationProperties.getInstance().setScopeChecker(scopeChecker);
            ProfileExportVisitorImpl profileVisitor = new ProfileExportVisitorImpl(progressBar);
            PExportProfile pprofile = new PExportProfile(rootProfile);
            profileVisitor.visit(pprofile);
            if (progressBar != null) {
                progressBar.setLabel(XMI.I18N.getString("progressBar.content.export.XMIFileSave"));
            }
            ObjingEAnnotation.setExporterVersion((Element)ecoreProfile, (String)version);
            resource.getContents().add((Object)ecoreProfile);
            try {
                resource.save(null);
            }
            catch (Exception ioe) {
                error = true;
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)ioe);
            }
            if (error) {
                LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_failed"));
            } else {
                LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_done"));
                if (progressBar != null) {
                    progressBar.addFinalValue();
                }
            }
        }
        return error;
    }

    private boolean saveRessource(Resource resource) {
        File file = new File(resource.getURI().toFileString());
        if (file.exists()) {
            file.delete();
        }
        try {
            resource.save(null);
        }
        catch (IOException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            return true;
        }
        return false;
    }

    private void exportStereotype(IModelElement element, Element ecoreElement) {
        GenerationProperties genProp = GenerationProperties.getInstance();
        for (IStereotype stereotype : element.getExtension()) {
            Stereotype ecoreStereotype = (Stereotype)genProp.getMappedElement((IElement)stereotype);
            if (ecoreStereotype == null || !ecoreElement.isStereotypeApplicable(ecoreStereotype) || ecoreElement.getAppliedStereotypes().contains((Object)ecoreStereotype)) continue;
            try {
                ecoreElement.applyStereotype(ecoreStereotype);
            }
            catch (IllegalArgumentException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
        }
        for (ITaggedValue taggedValue : element.getTag()) {
            Stereotype ecoreStereotype;
            IMetaclassReference metaclassReference = taggedValue.getDefinition().getOwnerReference();
            if (metaclassReference == null || (ecoreStereotype = (Stereotype)genProp.getMappedElement((IElement)metaclassReference)) == null || !ecoreElement.isStereotypeApplicable(ecoreStereotype) || ecoreElement.getAppliedStereotypes().contains((Object)ecoreStereotype)) continue;
            ecoreElement.applyStereotype(ecoreStereotype);
        }
    }

    private void applySysML() {
        GenerationProperties genProp = GenerationProperties.getInstance();
        Profile sysMLProfile = genProp.getSysMLProfile();
        for (IModelElement element : genProp.getSysMLExported()) {
            Stereotype ratStereotype;
            Element ecoreElement = genProp.getMappedElement((IElement)element);
            if (ecoreElement == null) continue;
            if (element instanceof IRequirement) {
                IRequirement requirement = (IRequirement)element;
                Stereotype requirementSter = sysMLProfile.getOwnedStereotype("Requirement");
                try {
                    ecoreElement.applyStereotype(requirementSter);
                    ecoreElement.setValue(requirementSter, "Text", (Object)requirement.getText());
                    ecoreElement.setValue(requirementSter, "Id", (Object)requirement.getName());
                }
                catch (Exception e) {
                    String errorMsg = e.getMessage();
                    if (errorMsg == null) continue;
                    LOG.error((String)"org.modelio.xmi.internal", (String)errorMsg);
                }
                continue;
            }
            if (element instanceof IDependency) {
                IDependency dependency = (IDependency)element;
                try {
                    if (element.isStereotyped("satisfy")) {
                        Stereotype satisfyStereotype = sysMLProfile.getOwnedStereotype("Satisfy");
                        genProp.getMappedElement((IElement)dependency).applyStereotype(satisfyStereotype);
                        this.setRequirementsRelated(dependency);
                        continue;
                    }
                    if (element.isStereotyped("verify")) {
                        Stereotype verifyStereotype = sysMLProfile.getOwnedStereotype("Verify");
                        genProp.getMappedElement((IElement)dependency).applyStereotype(verifyStereotype);
                        this.setRequirementsRelated(dependency);
                        continue;
                    }
                    if (!element.isStereotyped("derive")) continue;
                    Stereotype deriveStereotype = sysMLProfile.getOwnedStereotype("DeriveReqt");
                    genProp.getMappedElement((IElement)dependency).applyStereotype(deriveStereotype);
                    this.setRequirementsRelated(dependency);
                }
                catch (IllegalArgumentException e) {
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                }
                continue;
            }
            if (!(element instanceof INote)) continue;
            INote note = (INote)element;
            if (note.getModel().getName().equals("Rationale")) {
                ratStereotype = sysMLProfile.getOwnedStereotype("Rationale");
                genProp.getMappedElement((IElement)note).applyStereotype(ratStereotype);
                continue;
            }
            if (!note.getModel().getName().equals("Problem")) continue;
            ratStereotype = sysMLProfile.getOwnedStereotype("Problem");
            genProp.getMappedElement((IElement)note).applyStereotype(ratStereotype);
        }
        genProp.cleanSysMLElementExported();
    }

    private void setRequirementsRelated(IDependency element) {
        if (!(element.getDependsOn() instanceof IRequirement)) {
            this.setRequirementRelated(GenerationProperties.getInstance().getMappedElement((IElement)element.getDependsOn()));
        }
        if (!(element.getImpacted() instanceof IRequirement)) {
            this.setRequirementRelated(GenerationProperties.getInstance().getMappedElement((IElement)element.getImpacted()));
        }
    }

    private void setRequirementRelated(Element mappedElement) {
        mappedElement.applyStereotype(GenerationProperties.getInstance().getSysMLProfile().getOwnedStereotype("RequirementRelated"));
    }

    private void profileDefinition() {
        for (Profile profile : GenerationProperties.getInstance().getExportedProfiles()) {
            profile.define();
        }
        if (GenerationProperties.getInstance().isSysMLApplied()) {
            GenerationProperties.getInstance().getSysMLProfile().define();
        }
    }

    static /* synthetic */ Shell access$0(ExportServices exportServices) {
        return exportServices._shell;
    }
}

