/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.generation;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.xmi.generation.IProfileExportVisitor;
import com.modeliosoft.modelio.xmi.gui.ProgressBarComposite;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportAttribut;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportGeneralization;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportNoteType;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportProfile;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportReference;
import com.modeliosoft.modelio.xmi.model.objing.profile.PExportStereotype;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;

public class ProfileExportVisitorImpl
implements IProfileExportVisitor {
    private ProgressBarComposite theProgressBar = null;

    public ProfileExportVisitorImpl(ProgressBarComposite progressBar) {
        this.theProgressBar = progressBar;
    }

    public ProfileExportVisitorImpl() {
    }

    public void visit(PExportProfile profile) {
        profile.visit();
        for (PExportProfile subProfile : profile.getSubProfiles()) {
            subProfile.accept(this);
            if (this.theProgressBar == null) continue;
            this.theProgressBar.addElement();
        }
        for (PExportProfile subProfile : ProfileUtils.getSubProfiles((PExportProfile)profile)) {
            subProfile.accept(this);
            if (this.theProgressBar == null) continue;
            this.theProgressBar.addElement();
        }
        for (PExportStereotype subStereotype : profile.getStereotypes()) {
            subStereotype.accept(this);
            if (this.theProgressBar == null) continue;
            this.theProgressBar.addElement();
            this.theProgressBar.addValue();
        }
        for (PExportReference subreference : profile.getReferences()) {
            subreference.accept(this);
            if (this.theProgressBar == null) continue;
            this.theProgressBar.addElement();
        }
    }

    public void visit(PExportStereotype stereotype) {
        stereotype.visit();
        IStereotype elt = (IStereotype)stereotype.getElt();
        PExportGeneralization generalization = new PExportGeneralization(elt.getBaseClassName(), elt);
        generalization.accept(this);
        for (PExportAttribut attribut : stereotype.getAttribute()) {
            attribut.accept(this);
        }
        for (PExportNoteType noteType : stereotype.getNoteTypes()) {
            noteType.accept(this);
        }
    }

    public void visit(PExportAttribut attribut) {
        attribut.visit();
    }

    public void visit(PExportGeneralization generalization) {
        generalization.visit();
    }

    public void visit(PExportReference reference) {
        reference.visit();
        for (PExportAttribut attribut : reference.getAttribute()) {
            attribut.accept(this);
        }
        for (PExportNoteType noteType : reference.getNoteTypes()) {
            noteType.accept(this);
        }
    }

    public void visit(PExportNoteType noteType) {
        noteType.visit();
    }
}

