/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.gui;

import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.api.VersionExport;
import com.modeliosoft.modelio.xmi.generation.ExportServices;
import com.modeliosoft.modelio.xmi.generation.PartialExportMap;
import com.modeliosoft.modelio.xmi.generation.TotalExportMap;
import com.modeliosoft.modelio.xmi.gui.ProgressBarComposite;
import com.modeliosoft.modelio.xmi.gui.XMIThread;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.AbortProcessException;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.XMIFileUtils;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class ExportProfileThread
extends XMIThread
implements IRunnableWithProgress {
    private ExportServices service = null;

    public ExportProfileThread(Shell shell, ProgressBarComposite progressBar) {
        XMILogs.getInstance().setLogFile(GenerationProperties.getInstance().getFilePath());
        XMILogs.getInstance().setEmpty(true);
        this.service = new ExportServices(shell);
        this.progressBar = progressBar;
        this.shell = shell;
    }

    public void run(IProgressMonitor localMonitor) {
        String errorMessage = "";
        Resource resource = null;
        try {
            try {
                GenerationProperties genProp = GenerationProperties.getInstance();
                this.progressBar.setNumberElement(this.service.countModelTrees((IModelTree)genProp.getSelectedPackage()) * 2);
                this.progressBar.setLabel(XMI.I18N.getString("progressBar.content.export.XMIFileInit"));
                resource = this.service.createResource(genProp.getFilePath());
                this.error = this.service.createEcoreProfile(resource, this.progressBar);
                if (!this.error) {
                    VersionExport versionExport = GenerationProperties.getInstance().getExportVersion();
                    if (!versionExport.equals((Object)VersionExport.EMF300)) {
                        XMIFileUtils.changeToUML((String)GenerationProperties.getInstance().getFilePath());
                    }
                    this.progressBar.addFinalValue();
                    this.completeBox();
                } else {
                    this.progressBar.addFinalValue();
                    this.incompleteBox(errorMessage);
                }
            }
            catch (AbortProcessException e) {
                this.cancelation();
                if (resource != null) {
                    resource.unload();
                }
                TotalExportMap.getInstance().clear();
                PartialExportMap.getInstance().clear();
            }
            catch (Exception e) {
                block14: {
                    errorMessage = e.getMessage();
                    if (errorMessage == null) {
                        errorMessage = XMI.I18N.getString("fileChooser.dialog.export.errorMessage");
                    }
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                    this.progressBar.addFinalValue();
                    this.incompleteBox(errorMessage);
                    if (resource == null) break block14;
                    resource.unload();
                }
                TotalExportMap.getInstance().clear();
                PartialExportMap.getInstance().clear();
            }
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
            TotalExportMap.getInstance().clear();
            PartialExportMap.getInstance().clear();
        }
    }
}

