/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.gui;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.gui.ProgressBarComposite;
import com.modeliosoft.modelio.xmi.gui.XMIThread;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.reverse.ImportServices;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.AbortProcessException;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImportThread
extends XMIThread
implements IRunnableWithProgress {
    private ImportServices service = null;

    public void run(IProgressMonitor localMonitor) {
        Resource resource = null;
        try {
            try {
                this.progressBar.setLabel(XMI.I18N.getString("progressBar.content.import.XMIFileLoading"));
                resource = this.service.getResource(new File(ReverseProperties.getInstance().getFilePath()));
                if (resource != null) {
                    this.error = this.service.importEcoreModel(resource, this.progressBar, this.shell);
                    this.progressBar.addFinalValue();
                    if (!this.error) {
                        this.completeBox();
                    }
                }
            }
            catch (AbortProcessException e) {
                this.cancelation();
                ReverseProperties.getInstance().setRollback(true);
                if (resource != null) {
                    resource.unload();
                }
                TotalImportMap.getInstance().clear();
                PartialImportMap.getInstance().clear();
            }
            catch (Exception e) {
                block13: {
                    File file;
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                    this.catchException(e.getMessage(), XMI.I18N.getString("error.import.invalidModel"));
                    if (resource != null && resource.getURI().toFileString().endsWith(".emf") && (file = new File(resource.getURI().toFileString())).exists()) {
                        file.delete();
                    }
                    this.progressBar.addFinalValue();
                    if (resource == null) break block13;
                    resource.unload();
                }
                TotalImportMap.getInstance().clear();
                PartialImportMap.getInstance().clear();
            }
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
            TotalImportMap.getInstance().clear();
            PartialImportMap.getInstance().clear();
        }
    }

    public ImportThread(Shell shell, ProgressBarComposite progressBar) {
        XMILogs.getInstance().setLogFile(ReverseProperties.getInstance().getFilePath());
        XMILogs.getInstance().setEmpty(true);
        this.service = new ImportServices();
        this.progressBar = progressBar;
        this.shell = shell;
    }

    private void catchException(String messageException, String titleException) {
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (messageException != null) {
            LOG.error((String)"org.modelio.xmi.internal", (String)messageException);
        }
        ReverseProperties.getInstance().setRollback(true);
    }
}

