/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.gui;

import com.modeliosoft.modelio.xmi.api.VersionExport;
import com.modeliosoft.modelio.xmi.api.XMIExtension;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OptionComposite
extends Composite {
    private Button compatibility = null;
    private Combo combo = null;
    private Label label = null;
    private Group groupOwner = null;
    private Group groupExtension = null;
    private Button xmi = null;
    private Button uml = null;
    private Group groupCompatibility = null;
    private VersionExport[] versions = VersionExport.values();

    public OptionComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FormLayout());
        this.groupOwner = new Group((Composite)this, 0);
        FormData fd_group = new FormData();
        fd_group.bottom = new FormAttachment(100, 0);
        fd_group.top = new FormAttachment(0, 0);
        fd_group.right = new FormAttachment(100, 0);
        fd_group.left = new FormAttachment(0, 0);
        this.groupOwner.setLayoutData((Object)fd_group);
        this.groupOwner.setText(XMI.I18N.getString("fileChooser.options.export.group.option.name"));
        this.groupCompatibility = new Group((Composite)this.groupOwner, 0);
        this.groupCompatibility.setBounds(35, 20, 350, 80);
        this.groupCompatibility.setText(XMI.I18N.getString("fileChooser.options.export.group.compatibility.name"));
        this.compatibility = new Button((Composite)this.groupCompatibility, 32);
        this.compatibility.setBounds(30, 20, 220, 16);
        this.compatibility.setText(XMI.I18N.getString("fileChooser.options.export.enableRoundtrip.name"));
        boolean compatibilityMdacParameterValue = Boolean.valueOf(XMI.getInstance().getModelingSession().getProjectPropertiesService().readProperty("Modelio", "Ui.Parameter.CompatibilityActivated"));
        this.compatibility.setSelection(compatibilityMdacParameterValue);
        this.combo = new Combo((Composite)this.groupCompatibility, 8);
        String currentExport = XMI.getInstance().getModelingSession().getProjectPropertiesService().readProperty("Modelio", "Ui.Parameter.VersionExport");
        int i = 0;
        while (i < this.versions.length) {
            this.combo.add(XMI.I18N.getString("Ui.Parameter.VersionExport." + this.versions[i].name()));
            if (this.versions[i].name().equals(currentExport)) {
                this.combo.select(i);
            }
            ++i;
        }
        this.combo.setBounds(130, 50, 150, 13);
        this.label = new Label((Composite)this.groupCompatibility, 64);
        this.label.setText(String.valueOf(XMI.I18N.getString("fileChooser.options.export.version.name")) + " : ");
        this.label.setBounds(40, 50, 90, 13);
        this.groupExtension = new Group((Composite)this.groupOwner, 0);
        this.groupExtension.setText(XMI.I18N.getString("fileChooser.options.export.group.extension.name"));
        this.groupExtension.setBounds(410, 20, 140, 80);
        this.xmi = new Button((Composite)this.groupExtension, 16);
        this.xmi.setBounds(40, 20, 100, 20);
        this.xmi.setText(".xmi");
        this.uml = new Button((Composite)this.groupExtension, 16);
        this.uml.setBounds(40, 50, 100, 20);
        this.uml.setText(".uml");
        String extension = XMI.getInstance().getModelingSession().getProjectPropertiesService().readProperty("Modelio", "Ui.Parameter.FileExtension");
        if (extension.equals(XMIExtension.XMI.toString())) {
            this.xmi.setSelection(true);
        } else {
            this.uml.setSelection(true);
        }
        this.groupOwner.pack();
    }

    public VersionExport getVersion() {
        return this.versions[this.combo.getSelectionIndex()];
    }

    public Button getUMLButton() {
        return this.uml;
    }

    public Button getXMIButton() {
        return this.xmi;
    }

    public XMIExtension getExtension() {
        if (this.uml.getSelection()) {
            return XMIExtension.UML;
        }
        return XMIExtension.XMI;
    }

    public Button getCompatibilityButton() {
        return this.compatibility;
    }

    public Label getLabelButton() {
        return this.label;
    }

    public Combo getComboButton() {
        return this.combo;
    }

    public void setUMLSelected() {
        this.uml.setSelection(true);
        this.xmi.setSelection(false);
    }

    public void setXMISelected() {
        this.xmi.setSelection(true);
        this.uml.setSelection(false);
    }

    public boolean isAnnoted() {
        return this.compatibility.getSelection();
    }
}

