/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.gui;

import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.xmi.gui.ImportThread;
import com.modeliosoft.modelio.xmi.gui.SwtWizardWindow;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.io.File;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SwtWizardImport
extends SwtWizardWindow {
    public void validationAction() {
        block9: {
            File theFile = this.getFileChooserComposite().getCurrentFile();
            ReverseProperties.getInstance().setFilePath(theFile);
            path = theFile.getParent();
            if (theFile.exists() && theFile.isFile()) {
                String extension = theFile.getName();
                if ((extension = extension.substring(extension.lastIndexOf("."))).equals(".uml") || extension.equals(".xmi") || extension.equals(".xml")) {
                    this.initTransaction();
                    try {
                        try {
                            IProgressService service = PlatformUI.getWorkbench().getProgressService();
                            service.busyCursorWhile((IRunnableWithProgress)new ImportThread(this.shell, this.getTheProgressBar()));
                        }
                        catch (Exception e) {
                            this.error = true;
                            this.catchException(e, XMI.I18N.getString("error.import.uncatchedException"));
                            this.commitTransaction();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        this.commitTransaction();
                        throw throwable;
                    }
                    this.commitTransaction();
                } else {
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                this.fileDontExist();
            }
        }
        this.enableComposites();
    }

    public void setLabels() {
        this.setTitle(XMI.I18N.getString("fileChooser.banner.import.title"));
        this.setDescription(XMI.I18N.getString("fileChooser.banner.import.description"));
        this.setFrametitle(XMI.I18N.getString("fileChooser.frame.import.title"));
        this.setCancelButton(XMI.I18N.getString("fileChooser.buttons.import.cancel.name"));
        this.setValidateButton(XMI.I18N.getString("fileChooser.buttons.import.import.name"));
    }

    public void setPath() {
        try {
            if (path.equals("")) {
                path = String.valueOf(ResourceLoader.getInstance().getProjectRoot()) + File.separator + "XMI";
            }
            this.fileChooserComposite.getDialog().setFilterPath(path);
            this.fileChooserComposite.getDialog().setFileName("");
            this.fileChooserComposite.setText(path);
        }
        catch (NoClassDefFoundError e) {
            this.fileChooserComposite.setText("");
        }
    }

    public void setDefaultDialog() {
        this.fileChooserComposite.getDialog().setFilterNames(new String[]{"All Files (*.xmi; *.uml; *.xml)", "XMI Files (*.xmi)", "UML Files (*.uml)", "XML Files (*.xml)"});
        this.fileChooserComposite.getDialog().setFilterExtensions(new String[]{"*.xmi; *.uml; *.xml", "*.xmi", "*.uml", "*.xml"});
        this.setPath();
    }

    public SwtWizardImport(Shell parent, int style) {
        super(parent, style);
        this.setSelectedType(4096);
        this.exportWindows = false;
    }

    public SwtWizardImport(Shell parent) {
        this(parent, 0);
    }

    public void setOptionComposite(Shell shell) {
        this.optionComposite = null;
    }

    private void initTransaction() {
        ITransaction t = XMI.getInstance().getModelingSession().getTransactionManager().createTransaction("Create-update objing model from XMI");
        ReverseProperties.getInstance().setOpenedTransaction(t);
    }

    private void commitTransaction() {
        ITransaction t = ReverseProperties.getInstance().getOpenedTransaction();
        ITransactionManager tm = XMI.getInstance().getModelingSession().getTransactionManager();
        if (this.error) {
            tm.rollback(t);
            t = null;
        } else if (ReverseProperties.getInstance().isRollback()) {
            tm.rollback(t);
            t = null;
            ReverseProperties.getInstance().setRollback(false);
        } else {
            try {
                tm.commit(t);
            }
            catch (InvalidTransactionException e) {
                tm.rollback(t);
                t = null;
            }
        }
    }

    private void catchException(Exception e, String title) {
        LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        String text = e.getStackTrace()[0].toString();
        String msgTitle = title;
        Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

