/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.gui;

import com.modeliosoft.modelio.api.model.InvalidTransactionException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.xmi.gui.ImportProfileThread;
import com.modeliosoft.modelio.xmi.gui.SwtWizardWindow;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.ResourceLoader;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.io.File;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class SwtWizardImportProfile
extends SwtWizardWindow {
    public SwtWizardImportProfile(Shell parent, int style) {
        super(parent, style);
        this.setSelectedType(4096);
        this.exportWindows = false;
    }

    public SwtWizardImportProfile(Shell parent) {
        this(parent, 0);
    }

    public void validationAction() {
        block21: {
            File theFile = this.getFileChooserComposite().getCurrentFile();
            ReverseProperties.getInstance().setFilePath(theFile);
            path = theFile.getParent();
            ITransactionManager tm = null;
            ITransaction t = null;
            IModelingSession session = null;
            if (theFile.exists() && theFile.isFile()) {
                session = XMI.getInstance().getModelingSession();
                tm = session.getTransactionManager();
                t = tm.createTransaction("Create-update Profile");
                ReverseProperties revProp = ReverseProperties.getInstance();
                try {
                    revProp.setOpenedTransaction(t);
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    service.busyCursorWhile((IRunnableWithProgress)new ImportProfileThread(this.shell, this.getTheProgressBar(), this.getSelectedPkg()));
                }
                catch (InvalidTransactionException e) {
                    this.error = true;
                    LOG.error((String)"org.modelio.xmi.internal", (String)"InvalidTransactionException : ");
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                    t = revProp.getOpenedTransaction();
                    if (this.error) {
                        tm.rollback(t);
                        t = null;
                    } else if (revProp.isRollback()) {
                        tm.rollback(t);
                        t = null;
                        revProp.setRollback(false);
                    } else {
                        tm.commit(t);
                    }
                    break block21;
                }
                catch (Exception e) {
                    try {
                        this.error = true;
                        LOG.error((String)"org.modelio.xmi.internal", (String)"Exception : ");
                        LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                        break block21;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        t = revProp.getOpenedTransaction();
                        if (this.error) {
                            tm.rollback(t);
                            t = null;
                        } else if (revProp.isRollback()) {
                            tm.rollback(t);
                            t = null;
                            revProp.setRollback(false);
                        } else {
                            tm.commit(t);
                        }
                    }
                }
                t = revProp.getOpenedTransaction();
                if (this.error) {
                    tm.rollback(t);
                    t = null;
                } else if (revProp.isRollback()) {
                    tm.rollback(t);
                    t = null;
                    revProp.setRollback(false);
                } else {
                    tm.commit(t);
                }
            } else {
                this.fileDontExist();
            }
        }
        this.enableComposites();
    }

    public void setLabels() {
        this.setTitle(XMI.I18N.getString("fileChooser.banner.importProfile.title"));
        this.setDescription(XMI.I18N.getString("fileChooser.banner.import.description"));
        this.setFrametitle(XMI.I18N.getString("fileChooser.frame.importProfile.title"));
        this.setCancelButton(XMI.I18N.getString("fileChooser.buttons.import.cancel.name"));
        this.setValidateButton(XMI.I18N.getString("fileChooser.buttons.import.import.name"));
    }

    public void setOptionComposite(Shell shell) {
        this.optionComposite = null;
    }

    public void setDefaultDialog() {
        this.fileChooserComposite.getDialog().setFilterNames(new String[]{"All Files (*.xmi; *.uml; *.xml)", "XMI Files (*.xmi)", "UML Files (*.uml)", "XML Files (*.xml)"});
        this.fileChooserComposite.getDialog().setFilterExtensions(new String[]{"*.xmi; *.uml; *.xml", "*.xmi", "*.uml", "*.xml"});
        this.setPath();
    }

    public void setPath() {
        String importPath = XMI.getInstance().getModelingSession().getProjectPropertiesService().readProperty("Modelio", "Ui.Parameter.ImportPath");
        if (importPath == null || importPath.equals("")) {
            importPath = String.valueOf(ResourceLoader.getInstance().getProjectRoot()) + File.separator + "XMI";
        }
        this.fileChooserComposite.getDialog().setFilterPath(importPath);
        this.fileChooserComposite.getDialog().setFileName("");
        this.fileChooserComposite.setText(importPath);
    }
}

