/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.gui.report;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.xmi.gui.report.IReportWriter;
import com.modeliosoft.modelio.xmi.gui.report.ReportModel;
import java.util.Set;
import java.util.TreeSet;

public class ReportModel
implements IReportWriter {
    private Set<ElementMessage> errors = new TreeSet();
    private Set<ElementMessage> warnings = new TreeSet();
    private Set<ElementMessage> infos = new TreeSet();

    public void addWarning(String initialMessage, IElement element, String description) {
        String message = initialMessage;
        if (message == null) {
            message = "";
        }
        this.warnings.add(new ElementMessage(this, message, element, description));
    }

    public void addError(String initialMessage, IElement element, String description) {
        String message = initialMessage;
        if (message == null) {
            message = "";
        }
        this.errors.add(new ElementMessage(this, message, element, description));
    }

    public Set<ElementMessage> getErrors() {
        return this.errors;
    }

    public Set<ElementMessage> getWarnings() {
        return this.warnings;
    }

    public boolean isEmpty() {
        return !this.hasErrors() && !this.hasWarnings() && !this.hasInfos();
    }

    public void addWarning(String message, IElement element) {
        this.warnings.add(new ElementMessage(this, message, element, ""));
    }

    public void addError(String message, IElement element) {
        this.errors.add(new ElementMessage(this, message, element, ""));
    }

    public void addInfo(String message, IElement element, String description) {
        this.infos.add(new ElementMessage(this, message, element, description));
    }

    public void addInfo(String message, IElement element) {
        this.infos.add(new ElementMessage(this, message, element, ""));
    }

    public Set<ElementMessage> getInfos() {
        return this.infos;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasInfos() {
        return !this.infos.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }
}

