/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.impl;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.xmi.api.ExportConfiguration;
import com.modeliosoft.modelio.xmi.api.IXMI;
import com.modeliosoft.modelio.xmi.api.ImportConfiguration;
import com.modeliosoft.modelio.xmi.api.VersionExport;
import com.modeliosoft.modelio.xmi.generation.ExportServices;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.reverse.ImportServices;
import com.modeliosoft.modelio.xmi.util.AbortProcessException;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.XMIFileUtils;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.io.File;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class XMIImpl
implements IXMI {
    private ImportServices importService = null;
    private ExportServices exportService = null;

    private void cancelProcess(Shell shell) {
        if (shell != null && !System.getProperty("os.name").equals("Linux")) {
            shell.dispose();
        }
        LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.import.result_failed"));
        ITransaction t = ReverseProperties.getInstance().getOpenedTransaction();
        if (t != null) {
            XMI.getInstance().getModelingSession().getTransactionManager().rollback(t);
            t = null;
        }
    }

    private void commitTransaction(boolean error) {
        ITransaction t = ReverseProperties.getInstance().getOpenedTransaction();
        ITransactionManager tm = XMI.getInstance().getModelingSession().getTransactionManager();
        if (error) {
            tm.rollback(t);
            t = null;
        } else if (ReverseProperties.getInstance().isRollback()) {
            tm.rollback(t);
            t = null;
            ReverseProperties.getInstance().setRollback(false);
        } else {
            tm.commit(t);
        }
    }

    private void exportModel(ExportConfiguration configuration) {
        Shell shell = null;
        try {
            try {
                String xmiFilePath = configuration.getXmiFile().getAbsolutePath();
                GenerationProperties.getInstance().setSelectedPackage(configuration.getEntryPoint());
                Resource resource = this.exportService.createResource(xmiFilePath);
                GenerationProperties.getInstance().setRoundtripEnabled(configuration.exportedAnotation().booleanValue());
                this.exportService.createEcoreModel(resource, null);
                if (!configuration.getVersionExport().equals((Object)VersionExport.EMF300)) {
                    XMIFileUtils.changeToUML((String)xmiFilePath);
                }
                LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_done"));
            }
            catch (AbortProcessException e) {
                this.cancelProcess(shell);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
            catch (Exception e) {
                this.cancelProcess(shell);
                LOG.error((String)"org.modelio.xmi.internal", (String)"Erreur.");
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
        }
        finally {
            XMILogs logs = XMILogs.getInstance();
            logs.saveLog();
        }
    }

    public void exportXMIFile(ExportConfiguration configuration) throws Exception {
        if (configuration.getEntryPoint() == null) {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.nullGivenParameter"));
        } else if (configuration.getXmiFile() != null) {
            this.initExportService(configuration.getEntryPoint());
            GenerationProperties.getInstance().setFilePath(configuration.getXmiFile());
            this.exportModel(configuration);
        } else {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.invalidFilePath"));
        }
    }

    private boolean importModel(File xmiFile) {
        boolean error = false;
        IModelingSession session = XMI.getInstance().getModelingSession();
        ITransaction t = session.getTransactionManager().createTransaction("Create-update objing model from XMI");
        ReverseProperties.getInstance().setOpenedTransaction(t);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            try {
                Resource resource = this.importService.getResource(xmiFile);
                if (resource != null) {
                    error = this.importService.importEcoreModel(resource, null, shell);
                }
            }
            catch (AbortProcessException resource) {
                this.commitTransaction(error);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
            catch (Exception e) {
                error = true;
                LOG.error((String)"org.modelio.xmi.internal", (String)"Erreur.");
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                this.commitTransaction(error);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
        }
        finally {
            this.commitTransaction(error);
            XMILogs logs = XMILogs.getInstance();
            logs.saveLog();
        }
        return error;
    }

    private void initExportService(IPackage entryPoint) {
        GenerationProperties genProp = GenerationProperties.getInstance();
        genProp.initialize();
        genProp.setTimeDisplayerActivated(false);
        genProp.setSelectedPackage(entryPoint);
        if (this.exportService == null) {
            this.exportService = new ExportServices(null);
        }
    }

    private void initImportService() {
        ReverseProperties.getInstance().initialize();
        if (this.importService == null) {
            this.importService = new ImportServices();
        }
    }

    public void importXMIModel(ImportConfiguration configuration) {
        if (configuration.getXmiFile() != null && configuration.getXmiFile().isFile()) {
            this.initImportService();
            ReverseProperties.getInstance().setUMLRoot((IPackage)configuration.getOwner());
            this.importModel(configuration.getXmiFile());
        } else {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.invalidFilePath"));
        }
    }

    public void importXMIProfile(ImportConfiguration configuration) {
        if (configuration.getOwner() != null && configuration.getOwner() instanceof IModule) {
            if (configuration.getXmiFile() != null && configuration.getXmiFile().isFile()) {
                this.initImportService();
                this.importProfile(configuration.getXmiFile(), (IModule)configuration.getOwner());
            } else {
                LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.invalidFilePath"));
            }
        } else {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.invalidOwner"));
        }
    }

    public void exportXMIProfile(ExportConfiguration configuration) throws Exception {
        if (configuration.getEntryPoint() == null || !(configuration.getEntryPoint() instanceof IProfile)) {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.nullGivenParameter"));
        } else if (configuration.getXmiFile() != null) {
            this.initExportService((IPackage)((IProfile)configuration.getEntryPoint()));
            GenerationProperties.getInstance().setFilePath(configuration.getXmiFile());
            this.exportProfile(configuration);
        } else {
            LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("error.invalidFilePath"));
        }
    }

    private void exportProfile(ExportConfiguration configuration) {
        Shell shell = null;
        try {
            try {
                String xmiFilePath = configuration.getXmiFile().getAbsolutePath();
                GenerationProperties.getInstance().setSelectedPackage((IPackage)((IProfile)configuration.getEntryPoint()));
                Resource resource = this.exportService.createResource(xmiFilePath);
                GenerationProperties.getInstance().setRoundtripEnabled(configuration.exportedAnotation().booleanValue());
                this.exportService.createEcoreProfile(resource, null);
                if (!configuration.getVersionExport().equals((Object)VersionExport.EMF300)) {
                    XMIFileUtils.changeToUML((String)xmiFilePath);
                }
                LOG.error((String)"org.modelio.xmi.internal", (String)XMI.I18N.getString("info.export.result_done"));
            }
            catch (AbortProcessException e) {
                this.cancelProcess(shell);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
            catch (Exception e) {
                this.cancelProcess(shell);
                LOG.error((String)"org.modelio.xmi.internal", (String)"Erreur.");
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
        }
        finally {
            XMILogs logs = XMILogs.getInstance();
            logs.saveLog();
        }
    }

    private boolean importProfile(File xmiFile, IModule module) {
        boolean error = false;
        IModelingSession session = XMI.getInstance().getModelingSession();
        ITransaction t = session.getTransactionManager().createTransaction("Create-update objing model from XMI");
        ReverseProperties.getInstance().setOpenedTransaction(t);
        Shell shell = Display.getDefault().getActiveShell();
        try {
            try {
                Resource resource = this.importService.getResource(xmiFile);
                if (resource != null) {
                    error = this.importService.importEcoreProfile(resource, (IElement)module, null, shell);
                }
            }
            catch (AbortProcessException resource) {
                this.commitTransaction(error);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
            catch (Exception e) {
                error = true;
                LOG.error((String)"org.modelio.xmi.internal", (String)"Erreur.");
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                this.commitTransaction(error);
                XMILogs logs = XMILogs.getInstance();
                logs.saveLog();
            }
        }
        finally {
            this.commitTransaction(error);
            XMILogs logs = XMILogs.getInstance();
            logs.saveLog();
        }
        return error;
    }
}

