/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IClass;
import com.modeliosoft.modelio.api.model.uml.statik.IClassAssociation;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.INode;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.xmi.model.ecore.ENamedElement;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class EAssociationClass
extends ENamedElement
implements IEElement {
    private boolean isDeleted = false;
    private IClassAssociation objingClassAssociation = null;
    private IAssociation objingAssociation = null;
    private IClass objingClass = null;

    public IClass createObjingElt() {
        this.objingClassAssociation = Modelio.getInstance().getModelingSession().getModel().createClassAssociation();
        this.objingClass = Modelio.getInstance().getModelingSession().getModel().createClass();
        this.objingAssociation = Modelio.getInstance().getModelingSession().getModel().createAssociation();
        this.objingClassAssociation.setClassPart(this.objingClass);
        this.objingClassAssociation.setAssociationPart(this.objingAssociation);
        return this.objingClass;
    }

    private void attachClass() {
        if (!this.isDeleted) {
            ReverseProperties revProp = ReverseProperties.getInstance();
            Element ecoreOwner = this.getEcoreElement().getOwner();
            if (ecoreOwner != null) {
                Object objingOwner = revProp.getMappedElement(ecoreOwner);
                if (objingOwner instanceof IProfile) {
                    this.objingClass.setOwner((IModelTree)revProp.getExternalPackage());
                } else if (objingOwner instanceof IModelTree) {
                    this.objingClass.setOwner((IModelTree)objingOwner);
                } else if (objingOwner instanceof IClass) {
                    this.objingClass.setOwner((IModelTree)((IClass)objingOwner));
                } else if (objingOwner instanceof INode) {
                    this.objingClass.setOwner((IModelTree)((INode)objingOwner));
                } else {
                    this.objingClass.setOwner((IModelTree)revProp.getExternalPackage());
                }
            } else {
                this.objingClass.setOwner((IModelTree)revProp.getExternalPackage());
            }
        }
    }

    private void attachAssociation() {
        if (!this.isDeleted) {
            ReverseProperties revProp = ReverseProperties.getInstance();
            int nbEnds = 0;
            for (Object memberEnd : ((AssociationClass)this.getEcoreElement()).getMemberEnds()) {
                Object ends = revProp.getMappedElement((Element)memberEnd);
                IAssociationEnd objingAssocEnd = null;
                for (IModelElement end : (ArrayList)ends) {
                    if (!(end instanceof IAssociationEnd)) continue;
                    objingAssocEnd = (IAssociationEnd)end;
                    break;
                }
                if (objingAssocEnd == null) continue;
                objingAssocEnd.setRelated(this.objingAssociation);
                ++nbEnds;
            }
            if (nbEnds != 2) {
                this.objingAssociation.delete();
                this.objingAssociation = null;
            }
        }
    }

    private void setClassProperties() {
        if (!this.isDeleted) {
            ReverseProperties revProp = ReverseProperties.getInstance();
            this.setClassName();
            if (this.objingClass instanceof IClass) {
                this.setClassAbstract();
                this.setClassLeaf();
                this.setClassActive();
                if (revProp.isRoundtripEnabled()) {
                    this.setClassPrimitiveEAnnotation();
                    this.setClassMainEAnnotation();
                }
            }
        }
    }

    private void setClassName() {
        String name = ((AssociationClass)this.getEcoreElement()).getName();
        if (EcoreModelNavigation.isNotNull((String)name)) {
            this.objingClass.setName(name);
        } else {
            this.objingClass.setName("");
        }
    }

    private void setClassAbstract() {
        this.objingClass.setAbstract(((AssociationClass)this.getEcoreElement()).isAbstract());
    }

    private void setClassLeaf() {
        this.objingClass.setLeaf(((AssociationClass)this.getEcoreElement()).isLeaf());
    }

    private void setClassActive() {
        this.objingClass.setActive(((AssociationClass)this.getEcoreElement()).isActive());
    }

    private void setClassPrimitiveEAnnotation() {
        this.objingClass.setElementary(ObjingEAnnotation.isPrimitive((Element)((AssociationClass)this.getEcoreElement())));
    }

    private void setClassMainEAnnotation() {
        this.objingClass.setMain(ObjingEAnnotation.isMain((Element)((AssociationClass)this.getEcoreElement())));
    }

    private void setAssociationProperties() {
        this.setAssocName();
    }

    private void setAssocName() {
        String name = ((AssociationClass)this.getEcoreElement()).getName();
        if (EcoreModelNavigation.isNotNull((String)name)) {
            this.objingAssociation.setName(name);
        } else {
            this.objingAssociation.setName("");
        }
    }

    private void deleteElements() {
        PartialImportMap.getInstance().remove((Object)this.getEcoreElement());
        TotalImportMap.getInstance().remove((Object)this.getEcoreElement());
        if (this.objingClass != null) {
            this.objingClass.delete();
        }
        if (this.objingAssociation != null) {
            this.objingAssociation.delete();
        }
        if (this.objingClassAssociation != null) {
            this.objingClassAssociation.delete();
        }
        this.isDeleted = true;
    }

    public EAssociationClass(AssociationClass element) {
        super((NamedElement)element);
    }

    public void attach(IElement objingElt) {
        this.initialize((IClass)objingElt);
        this.attachClass();
        this.attachAssociation();
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        this.setClassProperties();
        if (this.objingAssociation != null) {
            this.setAssociationProperties();
        }
    }

    private void initialize(IClass partialClass) {
        try {
            this.objingClass = partialClass;
            this.objingClassAssociation = (IClassAssociation)this.objingClass.getLinkToAssociation().get(0);
            this.objingAssociation = this.objingClassAssociation.getAssociationPart();
        }
        catch (Exception e) {
            this.deleteElements();
        }
    }
}

