/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.IUmlModel;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ProfileUtils;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.internal.impl.EnumerationLiteralImpl;
import org.eclipse.uml2.uml.internal.impl.ExtensionImpl;
import org.eclipse.uml2.uml.internal.impl.PrimitiveTypeImpl;

public class EElement
implements IEElement {
    private Element ecoreElt = null;

    public Element getEcoreElement() {
        return this.ecoreElt;
    }

    public void setStereotypes() {
        try {
            Object object = ReverseProperties.getInstance().getMappedElement(this.ecoreElt);
            if (object != null) {
                if (object instanceof IModelElement) {
                    IModelElement modelElement = (IModelElement)object;
                    if (modelElement.getTag() != null && modelElement.getTag().size() == 0 && modelElement.getExtension().size() == 0) {
                        for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                            this.setStereotype(modelElement, (Stereotype)stereo);
                        }
                    }
                    this.setStereotypesAnnotation(modelElement);
                } else if (object instanceof List) {
                    for (Object createdElt : (List)object) {
                        if (!(createdElt instanceof IModelElement)) continue;
                        IModelElement modelElement = (IModelElement)createdElt;
                        if (modelElement.getTag() != null && modelElement.getTag().size() == 0 && modelElement.getExtension().size() == 0) {
                            for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                                this.setStereotype(modelElement, (Stereotype)stereo);
                            }
                        }
                        this.setStereotypesAnnotation(modelElement);
                    }
                } else if (this.ecoreElt instanceof Manifestation) {
                    ArrayList list = (ArrayList)object;
                    for (IManifestation manifestation : list) {
                        if (manifestation.getTag() == null || manifestation.getTag().size() != 0 || manifestation.getExtension().size() != 0) continue;
                        for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                            this.setStereotype((IModelElement)manifestation, (Stereotype)stereo);
                        }
                    }
                } else if (this.ecoreElt instanceof Abstraction) {
                    ArrayList list = (ArrayList)object;
                    for (IDependency abstraction : list) {
                        if (abstraction.getTag() == null || abstraction.getTag().size() != 0 || abstraction.getExtension().size() != 1) continue;
                        for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                            this.setStereotype((IModelElement)abstraction, (Stereotype)stereo);
                        }
                    }
                } else if (this.ecoreElt instanceof Comment) {
                    ArrayList list = (ArrayList)object;
                    for (INote note : list) {
                        if (note.getTag() == null || note.getTag().size() != 0 || note.getExtension().size() != 0) continue;
                        for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                            this.setStereotype((IModelElement)note, (Stereotype)stereo);
                        }
                    }
                } else if (this.ecoreElt instanceof Dependency) {
                    ArrayList list = (ArrayList)object;
                    for (IModelElement dependency : list) {
                        if (dependency.getTag() == null || dependency.getTag().size() != 0 || dependency.getExtension().size() != 0) continue;
                        for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                            this.setStereotype(dependency, (Stereotype)stereo);
                        }
                    }
                } else if (this.ecoreElt instanceof Usage) {
                    ArrayList list = (ArrayList)object;
                    for (IModelElement usage : list) {
                        if (usage.getTag() == null || usage.getTag().size() != 0 || usage.getExtension().size() != 0) continue;
                        for (Object stereo : this.ecoreElt.getAppliedStereotypes()) {
                            this.setStereotype(usage, (Stereotype)stereo);
                        }
                    }
                }
            }
        }
        catch (ObElementNotFoundException e) {
            String errorMsg = e.getMessage();
            LOG.warning((String)"org.modelio.xmi.internal", (String)errorMsg);
        }
    }

    public EElement(Element element) {
        this.ecoreElt = element;
    }

    private void setStereotype(IModelElement objElement, Stereotype stereotype) {
        ProfileUtils.createObjProfile((Profile)stereotype.getProfile());
        ProfileUtils.addExtension((IModelElement)objElement, (Stereotype)stereotype);
        ArrayList<Property> listStereotypeProperties = new ArrayList<Property>();
        for (Object attribute : stereotype.getOwnedAttributes()) {
            if (!(attribute instanceof Property) || ((Property)attribute).getAssociation() instanceof ExtensionImpl) continue;
            listStereotypeProperties.add((Property)attribute);
        }
        for (Property property : listStereotypeProperties) {
            this.setProperties(objElement, stereotype, property, listStereotypeProperties);
        }
    }

    private void setProperties(IModelElement objModelElement, Stereotype stereotype, Property property, List<Property> listStereotypeProperties) {
        String propertyName = property.getName();
        ProfileUtils.visitProperty((Property)property);
        IUmlModel model = Modelio.getInstance().getModelingSession().getModel();
        Type ecoreType = property.getType();
        ITagType tagType = null;
        String taggedValueId = ObjingEAnnotation.getTaggedValue((Element)property);
        List tagTypes = (List)TotalImportMap.getInstance().get((Object)property);
        for (IModelElement tagTypeTemp : tagTypes) {
            if (!(tagTypeTemp instanceof ITagType) || !objModelElement.getExtension().contains((Object)((ITagType)tagTypeTemp).getOwnerStereotype())) continue;
            tagType = (ITagType)tagTypeTemp;
        }
        if (tagType != null) {
            if (taggedValueId != null && !taggedValueId.equals("")) {
                Object propertyValue = this.ecoreElt.getValue(stereotype, propertyName);
                if (propertyValue != null) {
                    if (propertyValue.equals(true)) {
                        this.createTaggedValue(tagType, objModelElement);
                    } else if (!propertyValue.equals(false)) {
                        this.setStringProperty(objModelElement, stereotype, tagType, taggedValueId, listStereotypeProperties);
                    }
                }
            } else {
                Object value = this.ecoreElt.getValue(stereotype, propertyName);
                if (value != null && !value.equals(false)) {
                    ITaggedValue taggedValue = this.createTaggedValue(tagType, objModelElement);
                    if (!value.equals(true) && property.getType() != null) {
                        String currentEcoreTypeName = ecoreType.getName();
                        if (currentEcoreTypeName == null) {
                            currentEcoreTypeName = ecoreType instanceof PrimitiveTypeImpl ? ((PrimitiveTypeImpl)ecoreType).eProxyURI().fragment() : ecoreType.eResource().getURI().fragment();
                        }
                        if (currentEcoreTypeName.equals("String")) {
                            if (value instanceof String) {
                                model.createTagParameter((String)value, taggedValue);
                            } else if (value instanceof EDataTypeUniqueEList) {
                                EDataTypeUniqueEList tabString = (EDataTypeUniqueEList)value;
                                for (String singleValue : tabString) {
                                    model.createTagParameter(singleValue, taggedValue);
                                }
                            }
                        } else if (ecoreType instanceof Class && EcoreModelNavigation.isMetaclass((Class)((Class)ecoreType)) && value instanceof Element) {
                            if (value instanceof NamedElement) {
                                model.createTagParameter(((NamedElement)value).getName(), taggedValue);
                            } else {
                                model.createTagParameter(value.toString(), taggedValue);
                            }
                        } else if (value instanceof EnumerationLiteralImpl) {
                            model.createTagParameter(((EnumerationLiteralImpl)value).getName(), taggedValue);
                        } else {
                            model.createTagParameter(value.toString(), taggedValue);
                        }
                    }
                }
            }
        }
    }

    private void setStringProperty(IModelElement objModelElement, Stereotype stereotype, ITagType tagType, String taggedValueId, List<Property> listStereotypeProperties) {
        IUmlModel model = Modelio.getInstance().getModelingSession().getModel();
        ITaggedValue taggedValue = this.createTaggedValue(tagType, objModelElement);
        ArrayList<Property> toBeRemoved = new ArrayList<Property>();
        for (Property attribute : listStereotypeProperties) {
            String ecoreTaggedValueId = ObjingEAnnotation.getTaggedValue((Element)attribute);
            if (ObjingEAnnotation.isTagParameter((Element)attribute) || ecoreTaggedValueId == null || !ecoreTaggedValueId.equals(taggedValueId) || !tagType.getName().equals(attribute.getName())) continue;
            Object value = this.ecoreElt.getValue(stereotype, attribute.getName());
            if (value != null && !(value instanceof Boolean)) {
                ITagParameter tagParameter = model.createTagParameter();
                taggedValue.setQualifier(tagParameter);
                tagParameter.setValue(value.toString());
            }
            toBeRemoved.add(attribute);
        }
        listStereotypeProperties.removeAll(toBeRemoved);
        toBeRemoved.clear();
        for (Property attribute : listStereotypeProperties) {
            Object value;
            if (!ObjingEAnnotation.isTagParameter((Element)attribute) || !ObjingEAnnotation.getTaggedValue((Element)attribute).equals(taggedValueId) || !tagType.getName().equals(attribute.getName()) || (value = this.ecoreElt.getValue(stereotype, attribute.getName())) == null || value instanceof Boolean) continue;
            if (value instanceof EDataTypeUniqueEList) {
                EDataTypeUniqueEList tabString = (EDataTypeUniqueEList)value;
                if (tabString.size() != 0) {
                    for (String valeur : tabString) {
                        model.createTagParameter(valeur, taggedValue);
                    }
                } else {
                    model.createTagParameter("", taggedValue);
                }
            } else if (value instanceof String) {
                model.createTagParameter((String)value, taggedValue);
            }
            toBeRemoved.add(attribute);
        }
        listStereotypeProperties.removeAll(toBeRemoved);
        toBeRemoved.clear();
    }

    private void setStereotypesAnnotation(IModelElement modelElement) {
        String completeSter = ObjingEAnnotation.getStereotype((Element)this.ecoreElt);
        if (completeSter != null && !completeSter.equals("")) {
            int index = completeSter.lastIndexOf(":");
            String profile = completeSter.substring(0, index);
            String stereotype = completeSter.substring(index + 1, completeSter.length());
            ArrayList<IStereotype> objStereotypes = new ArrayList<IStereotype>();
            for (IModule currentModule : O.getDefault().getModelingSession().getModel().getProject().getInstalled()) {
                if (!currentModule.getName().equals("LocalModule")) continue;
                block1: for (IProfile currentProfile : currentModule.getOwnedProfile()) {
                    if (!currentProfile.getName().equals(profile)) continue;
                    for (IStereotype currentStereotype : currentProfile.getDefinedStereotype()) {
                        if (!currentStereotype.getName().equals(stereotype)) continue;
                        objStereotypes.add(currentStereotype);
                        continue block1;
                    }
                }
            }
            if (objStereotypes.size() != 0) {
                ObList objStereotypesClass = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotypes(modelElement.getClass());
                for (IStereotype objStereotype : objStereotypes) {
                    if (!objStereotypesClass.contains((Object)objStereotype)) continue;
                    IUmlModel model = Modelio.getInstance().getModelingSession().getModel();
                    modelElement.addExtension(objStereotype);
                    for (ITagType tagType : objStereotype.getDefinedTagType()) {
                        String value = ObjingEAnnotation.getObjingEAnnotation((Element)this.ecoreElt, (String)tagType.getName());
                        if (value.equals("")) continue;
                        ITaggedValue taggedValue = this.createTaggedValue(tagType, modelElement);
                        if (tagType.getParamNumber().equals(Character.valueOf('0')) && (!tagType.getParamNumber().equals(Character.valueOf('0')) || !value.equalsIgnoreCase("true"))) continue;
                        model.createTagParameter(value, taggedValue);
                    }
                }
            }
        }
    }

    private ITaggedValue createTaggedValue(ITagType tagType, IModelElement modelElt) {
        ITaggedValue taggedValue = Modelio.getInstance().getModelingSession().getModel().createTaggedValue();
        taggedValue.setDefinition(tagType);
        taggedValue.setAnnoted(modelElt);
        return taggedValue;
    }

    public void setProperties(IElement objingElt) {
        if (objingElt instanceof IModelElement) {
            this.setXMIImported((IModelElement)objingElt);
        }
    }

    private void setEcoreId(IModelElement objingElement) {
        IUmlModel model = Modelio.getInstance().getModelingSession().getModel();
        try {
            ITaggedValue tag = model.createTaggedValue("EcoreId", objingElement);
            ITagParameter param = model.createTagParameter();
            param.setValue(ObjingEAnnotation.getEcoreId((Element)this.getEcoreElement()));
            tag.setQualifier(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setXMIImported(IModelElement objingElement) {
        IUmlModel model = Modelio.getInstance().getModelingSession().getModel();
        try {
            ITaggedValue tag = model.createTaggedValue("XMIImported", objingElement);
            model.createTagParameter("true", tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object createObjingElt() {
        return null;
    }

    public void attach(IElement objingElt) {
    }

    public void attach(List<Object> objingElts) {
    }
}

