/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IInputPin;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.ObObjectNodeOrderingKindEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.model.ecore.EPin;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.TestIdentityAction;
import org.eclipse.uml2.uml.Type;

public class EInputPin
extends EPin
implements IEElement {
    private InputPin ecoreElement;

    public IElement createObjingElt() {
        InputPin input;
        IInputPin element = Modelio.getInstance().getModelingSession().getModel().createInputPin();
        if (this.ecoreElement.getOwner() instanceof TestIdentityAction) {
            if (((TestIdentityAction)this.ecoreElement.getOwner()).getFirst().equals(this.ecoreElement)) {
                try {
                    IStereotype stereo = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IInputPin.class, "UML2First");
                    element.addExtension(stereo);
                }
                catch (StereotypeNotFoundException e) {
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                }
            } else if (((TestIdentityAction)this.ecoreElement.getOwner()).getSecond().equals(this.ecoreElement)) {
                try {
                    IStereotype stereo = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IInputPin.class, "UML2Second");
                    element.addExtension(stereo);
                }
                catch (StereotypeNotFoundException e) {
                    LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                }
            }
        } else if (this.ecoreElement.getOwner() instanceof CallOperationAction && (input = ((CallOperationAction)this.ecoreElement.getOwner()).getTarget()) != null && input.equals(this.ecoreElement)) {
            try {
                IStereotype stereo = Modelio.getInstance().getModelingSession().getMetamodelExtensions().getStereotype(IInputPin.class, "UML2Target");
                element.addExtension(stereo);
            }
            catch (StereotypeNotFoundException e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            }
        }
        return element;
    }

    public EInputPin(InputPin element) {
        super((Pin)element);
        this.ecoreElement = element;
    }

    public void attach(IElement objingElt) {
        this.attachToAction(objingElt);
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        this.setControlType((IInputPin)objingElt);
        this.setOrdering((IInputPin)objingElt);
        this.setSelectionBehavior((IInputPin)objingElt);
        this.setType((IInputPin)objingElt);
        this.setState((IInputPin)objingElt);
    }

    private void attachToAction(IElement objingElt) {
        Action ecoreAction = (Action)this.getEcoreElement().getOwner();
        Object objingAction = ReverseProperties.getInstance().getMappedElement((Element)ecoreAction);
        if (objingAction instanceof IActivityAction) {
            ((IInputPin)objingElt).setInputing((IActivityAction)objingAction);
        } else {
            XMILogs.getInstance().writelnInLog("owner of pin was " + objingAction.getClass().getSimpleName());
            objingElt.delete();
        }
    }

    private void setControlType(IInputPin pin) {
        pin.setControlType(this.ecoreElement.isControlType());
    }

    private void setOrdering(IInputPin pin) {
        switch (this.ecoreElement.getOrdering().getValue()) {
            case 3: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.F_I_F_O);
                break;
            }
            case 2: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.L_I_F_O);
                break;
            }
            case 1: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.ORDERED);
                break;
            }
            case 0: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.UNORDERED);
                break;
            }
            default: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.F_I_F_O);
            }
        }
    }

    private void setSelectionBehavior(IInputPin pin) {
        String behaviorName;
        Behavior ecoreBehavior = this.ecoreElement.getSelection();
        if (ecoreBehavior instanceof OpaqueBehavior) {
            String objingBehavior = "";
            for (Object body : ((OpaqueBehavior)ecoreBehavior).getBodies()) {
                objingBehavior = objingBehavior.concat((String)body);
            }
            pin.setSelectionBehavior(objingBehavior);
        } else if (ecoreBehavior != null && (behaviorName = ecoreBehavior.getName()) != null) {
            pin.setSelectionBehavior(behaviorName);
        }
    }

    private void setType(IInputPin pin) {
        Object objingType;
        Type ecoreType = this.ecoreElement.getType();
        if (ecoreType != null && (objingType = ReverseProperties.getInstance().getMappedElement((Element)ecoreType)) instanceof IGeneralClass) {
            pin.setType((IGeneralClass)objingType);
        }
    }

    private void setState(IInputPin pin) {
        Object objingState;
        State ecoreState;
        EList ecoreStates = this.ecoreElement.getInStates();
        if (ecoreStates != null && ecoreStates.size() > 0 && (ecoreState = (State)ecoreStates.get(0)) != null && (objingState = ReverseProperties.getInstance().getMappedElement((Element)ecoreState)) instanceof IState) {
            pin.setInState((IState)objingState);
        }
    }
}

