/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.IModelingSession;
import com.modeliosoft.modelio.api.model.diagrams.ISequenceDiagram;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IGate;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessage;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IMessageEnd;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IPartDecomposition;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObRelativeTimeEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ITransition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidInteractionManipulationException;
import com.modeliosoft.modelio.xmi.model.ecore.ENamedElement;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.model.ecore.sequence.LifelineImportMapper;
import com.modeliosoft.modelio.xmi.model.ecore.sequence.PartDecompositionImportMapper;
import com.modeliosoft.modelio.xmi.model.ecore.sequence.SequenceElementImportMapper;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.SequenceElementVisitor;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PartDecomposition;

public class EInteraction
extends ENamedElement
implements IEElement {
    private PartialImportMap partialCreationMap = PartialImportMap.getInstance();
    private Interaction ecoreElement;

    public IElement createObjingElt() {
        return Modelio.getInstance().getModelingSession().getModel().createInteraction();
    }

    public EInteraction(Interaction element) {
        super((NamedElement)element);
        this.ecoreElement = element;
    }

    public void attach(IElement objingElt) {
        Element ecoreOwner = this.ecoreElement.getOwner();
        ReverseProperties revProp = ReverseProperties.getInstance();
        Object objingOwner = revProp.getMappedElement(ecoreOwner);
        if (objingOwner != null) {
            IPackage finalOwner = null;
            if (objingOwner instanceof ITransition) {
                finalOwner = ObjingModelNavigation.getNearestPackage((IElement)((ITransition)objingOwner));
            } else if (objingOwner instanceof INameSpace) {
                finalOwner = (INameSpace)objingOwner;
            }
            if (finalOwner != null) {
                IInteraction objingIImport = (IInteraction)objingElt;
                objingIImport.setOwner((INameSpace)finalOwner);
            } else {
                objingElt.delete();
            }
        }
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        this.setReentrant((IInteraction)objingElt);
        this.createDiagramContext((IInteraction)objingElt);
        this.importLifelines();
        this.importPartDecomposition();
        this.importUnconnectedGates((IInteraction)objingElt);
        this.importSequencedElements((InteractionFragment)this.ecoreElement, ReverseProperties.getInstance().getSequenceElementVisitor());
    }

    private void setReentrant(IInteraction interaction) {
        interaction.setReentrant(this.ecoreElement.isReentrant());
    }

    private void createDiagramContext(IInteraction interaction) {
        IModelingSession session = Modelio.getInstance().getModelingSession();
        ISequenceDiagram seqDiag = session.getModel().createSequenceDiagram();
        String name = interaction.getName();
        if (EcoreModelNavigation.isNotNull((String)name)) {
            seqDiag.setName(name);
        }
        seqDiag.setOrigin((IModelElement)interaction);
        ReverseProperties.getInstance().addInteraction(this.ecoreElement);
    }

    private void importLifelines() {
        for (Lifeline ecoreLifeline : this.ecoreElement.getLifelines()) {
            LifelineImportMapper lifelineMapper = new LifelineImportMapper(ecoreLifeline);
            if (TotalImportMap.getInstance().get((Object)ecoreLifeline) != null) continue;
            ILifeline objingLifeline = null;
            if (this.partialCreationMap.get((Element)ecoreLifeline) == null) {
                objingLifeline = (ILifeline)lifelineMapper.createObjingElt();
                this.partialCreationMap.put((Element)ecoreLifeline, (Object)objingLifeline);
            } else {
                objingLifeline = (ILifeline)this.partialCreationMap.get((Element)ecoreLifeline);
                this.partialCreationMap.put((Element)ecoreLifeline, (Object)objingLifeline);
            }
            lifelineMapper.attach((IElement)objingLifeline);
            lifelineMapper.setProperties((IElement)objingLifeline);
            lifelineMapper.setStereotypes();
            TotalImportMap.getInstance().put((Object)ecoreLifeline, this.partialCreationMap.remove((Object)ecoreLifeline));
        }
    }

    private void importPartDecomposition() {
        for (Element ecoreIF : this.ecoreElement.getFragments()) {
            if (!(ecoreIF instanceof PartDecomposition)) continue;
            PartDecompositionImportMapper partDecompMapper = new PartDecompositionImportMapper((PartDecomposition)ecoreIF);
            if (TotalImportMap.getInstance().get((Object)ecoreIF) != null) continue;
            IPartDecomposition objingPD = null;
            if (this.partialCreationMap.get(ecoreIF) == null) {
                objingPD = (IPartDecomposition)partDecompMapper.createObjingElt();
                this.partialCreationMap.put(ecoreIF, (Object)objingPD);
            } else {
                objingPD = (IPartDecomposition)this.partialCreationMap.get(ecoreIF);
                this.partialCreationMap.put(ecoreIF, (Object)objingPD);
            }
            partDecompMapper.attach((IElement)objingPD);
            partDecompMapper.setProperties((IElement)objingPD);
            partDecompMapper.setStereotypes();
            TotalImportMap.getInstance().put((Object)ecoreIF, this.partialCreationMap.remove((Object)ecoreIF));
        }
    }

    private void importUnconnectedGates(IInteraction interaction) {
        for (Object ecoreGate : this.ecoreElement.getFormalGates()) {
            this.createUnconnectedGate((Gate)ecoreGate, interaction);
        }
    }

    public void createUnconnectedGate(Gate ecoreGate, IInteraction interaction) {
        String name;
        IGate objingGate = (IGate)ReverseProperties.getInstance().getMappedElement((Element)ecoreGate);
        if (objingGate == null) {
            objingGate = Modelio.getInstance().getModelingSession().getModel().createGate();
        }
        if (EcoreModelNavigation.isNotNull((String)(name = ecoreGate.getName()))) {
            objingGate.setName(name);
        }
        if (this.ecoreElement.getFormalGates().contains((Object)ecoreGate)) {
            interaction.addFormalGate(objingGate);
        }
        try {
            interaction.insert(objingGate, null, ObRelativeTimeEnum.AFTER);
            TotalImportMap.getInstance().put((Object)ecoreGate, (Object)objingGate);
        }
        catch (InvalidInteractionManipulationException e) {
            e.printStackTrace();
            this.partialCreationMap.remove((Object)ecoreGate);
            TotalImportMap.getInstance().remove((Object)ecoreGate);
            objingGate.delete();
        }
    }

    private void importSequencedElements(InteractionFragment ecoreIFContainer, SequenceElementVisitor sequenceVisitor) {
        ReverseProperties revProp = ReverseProperties.getInstance();
        ArrayList insertableEltsList = new ArrayList();
        ArrayList fragmentContainerList = new ArrayList();
        ArrayList mapperList = new ArrayList();
        for (InteractionFragment ecoreIF : this.getFragments(ecoreIFContainer)) {
            for (Element insertableElt : revProp.getInsertableIFVisitor().getInsertableElements(ecoreIF)) {
                this.addInsertableElement(insertableElt, sequenceVisitor, mapperList, insertableEltsList);
            }
            if (!(ecoreIF instanceof CombinedFragment)) continue;
            fragmentContainerList.addAll(((CombinedFragment)ecoreIF).getOperands());
        }
        this.insertElementsInDiagram(insertableEltsList, mapperList);
        for (InteractionFragment containerOfIF : fragmentContainerList) {
            this.importSequencedElements(containerOfIF, sequenceVisitor);
        }
    }

    private void addInsertableElement(Element insertableElt, SequenceElementVisitor sequenceVisitor, List<SequenceElementImportMapper> mapperList, List<Element> insertableEltsList) {
        Object objingInserted = TotalImportMap.getInstance().get((Object)insertableElt);
        if (objingInserted == null && (objingInserted = this.partialCreationMap.get(insertableElt)) == null) {
            SequenceElementImportMapper mapper = sequenceVisitor.getSequenceImportMapper(insertableElt);
            Object objingElt = mapper.createObjingElt();
            this.partialCreationMap.put(insertableElt, objingElt);
            if (insertableElt instanceof Message) {
                this.storeMappedEnds((Message)insertableElt, objingElt);
            }
            mapperList.add(mapper);
            insertableEltsList.add(insertableElt);
        }
    }

    private void storeMappedEnds(Message message, Object mappedElement) {
        Message replyMsg;
        MessageEnd receiveEvent;
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent != null && !(sendEvent instanceof Gate)) {
            TotalImportMap.getInstance().put((Object)sendEvent, mappedElement);
        }
        if ((receiveEvent = message.getReceiveEvent()) != null && !(receiveEvent instanceof Gate)) {
            TotalImportMap.getInstance().put((Object)receiveEvent, mappedElement);
        }
        if (!(sendEvent instanceof Gate) && (replyMsg = EcoreModelNavigation.getReplyMessage((Message)message)) != null) {
            this.partialCreationMap.put((Element)replyMsg, mappedElement);
            this.partialCreationMap.put((Element)replyMsg.getSendEvent(), mappedElement);
            this.partialCreationMap.put((Element)replyMsg.getReceiveEvent(), mappedElement);
        }
    }

    private List<InteractionFragment> getFragments(InteractionFragment ecoreIFContainer) {
        ArrayList<InteractionFragment> fragments = new ArrayList<InteractionFragment>();
        EList fragmentList = null;
        if (ecoreIFContainer instanceof Interaction) {
            fragmentList = ((Interaction)ecoreIFContainer).getFragments();
        } else if (ecoreIFContainer instanceof InteractionOperand) {
            fragmentList = ((InteractionOperand)ecoreIFContainer).getFragments();
        }
        if (fragmentList != null) {
            for (Object f : fragmentList) {
                fragments.add((InteractionFragment)f);
            }
        }
        return fragments;
    }

    private void insertElementsInDiagram(List<Element> insertableEltsList, List<SequenceElementImportMapper> mapperList) {
        ReverseProperties revProp = ReverseProperties.getInstance();
        int i = 0;
        while (i < insertableEltsList.size()) {
            Element ecoreInsertable = insertableEltsList.get(i);
            SequenceElementImportMapper mapper = mapperList.get(i);
            IElement objingElt = (IElement)revProp.getMappedElement(ecoreInsertable);
            mapper.attach(objingElt);
            mapper.setProperties(objingElt);
            mapper.setStereotypes();
            TotalImportMap.getInstance().put((Object)ecoreInsertable, this.partialCreationMap.remove((Object)ecoreInsertable));
            if (ecoreInsertable instanceof Message) {
                this.mapEcoreEndsToObjingEnds((Message)ecoreInsertable, (IMessage)objingElt);
            }
            ++i;
        }
    }

    private void mapEcoreEndsToObjingEnds(Message ecoreMsg, IMessage objingMsg) {
        IMessage oReplyMsg;
        Message eReplyMsg;
        MessageEnd eReceiveEvent;
        MessageEnd eSendEvent = ecoreMsg.getSendEvent();
        if (eSendEvent != null) {
            this.partialCreationMap.remove((Object)eSendEvent);
            IMessageEnd oSendEvent = objingMsg.getSendEvent();
            TotalImportMap.getInstance().put((Object)eSendEvent, (Object)oSendEvent);
        }
        if ((eReceiveEvent = ecoreMsg.getReceiveEvent()) != null) {
            this.partialCreationMap.remove((Object)eReceiveEvent);
            IMessageEnd oReceiveEvent = objingMsg.getReceiveEvent();
            TotalImportMap.getInstance().put((Object)eReceiveEvent, (Object)oReceiveEvent);
        }
        if ((eReplyMsg = EcoreModelNavigation.getReplyMessage((Message)ecoreMsg)) != null && (oReplyMsg = ObjingModelNavigation.getReplyMessage((IMessage)objingMsg)) != null) {
            MessageEnd eReceiveEventFromReply;
            this.partialCreationMap.remove((Object)eReplyMsg);
            TotalImportMap.getInstance().put((Object)eReplyMsg, (Object)oReplyMsg);
            MessageEnd eSendEventFromReply = eReplyMsg.getSendEvent();
            if (eSendEventFromReply != null) {
                this.partialCreationMap.remove((Object)eSendEventFromReply);
                IMessageEnd oSendEventFromReply = oReplyMsg.getSendEvent();
                TotalImportMap.getInstance().put((Object)eSendEventFromReply, (Object)oSendEventFromReply);
            }
            if ((eReceiveEventFromReply = eReplyMsg.getReceiveEvent()) != null) {
                this.partialCreationMap.remove((Object)eReceiveEventFromReply);
                IMessageEnd oReceiveEventFromReply = oReplyMsg.getReceiveEvent();
                TotalImportMap.getInstance().put((Object)eReceiveEventFromReply, (Object)oReceiveEventFromReply);
            }
        }
    }
}

