/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IObjectFlow;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.ObObjectFlowEffectKindEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.xmi.model.ecore.EActivityEdge;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.List;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ObjectFlow;
import org.eclipse.uml2.uml.OpaqueBehavior;

public class EObjectFlow
extends EActivityEdge
implements IEElement {
    private ObjectFlow ecoreElement;

    public IElement createObjingElt() {
        Object objingSource;
        ActivityNode ecoreSource = this.ecoreElement.getSource();
        ActivityNode ecoreTarget = this.ecoreElement.getTarget();
        if (ecoreSource != null && ecoreTarget != null && (objingSource = ReverseProperties.getInstance().getMappedElement((Element)ecoreSource)) != null && objingSource instanceof IActivityNode) {
            return Modelio.getInstance().getModelingSession().getModel().createObjectFlow();
        }
        return null;
    }

    public EObjectFlow(ObjectFlow element) {
        super((ActivityEdge)element);
        this.ecoreElement = element;
    }

    public void attach(IElement objingElt) {
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        this.setEffectEAnnotation((IObjectFlow)objingElt);
        this.setMultiCast((IObjectFlow)objingElt);
        this.setMultiReceive((IObjectFlow)objingElt);
        this.setSelectionBehavior((IObjectFlow)objingElt);
        this.setTransformationBehavior((IObjectFlow)objingElt);
    }

    private void setEffectEAnnotation(IObjectFlow flow) {
        String effect = ObjingEAnnotation.getEffect((Element)this.ecoreElement);
        if ("CREATE_FLOW".equals(effect)) {
            flow.setEffect(ObObjectFlowEffectKindEnum.CREATE_FLOW);
        } else if ("DELETE_FLOW".equals(effect)) {
            flow.setEffect(ObObjectFlowEffectKindEnum.DELETE_FLOW);
        } else if ("EXCEPTION_FLOW".equals(effect)) {
            flow.setEffect(ObObjectFlowEffectKindEnum.EXCEPTION_FLOW);
        } else if ("READ_FLOW".equals(effect)) {
            flow.setEffect(ObObjectFlowEffectKindEnum.READ_FLOW);
        } else if ("UPDATEFLOW".equals(effect)) {
            flow.setEffect(ObObjectFlowEffectKindEnum.UPDATEFLOW);
        } else {
            flow.setEffect(ObObjectFlowEffectKindEnum.READ_FLOW);
        }
    }

    private void setMultiCast(IObjectFlow flow) {
        flow.setMultiCast(this.ecoreElement.isMulticast());
    }

    private void setMultiReceive(IObjectFlow flow) {
        flow.setMultiReceive(this.ecoreElement.isMultireceive());
    }

    private void setSelectionBehavior(IObjectFlow flow) {
        String behaviorName;
        Behavior ecoreBehavior = this.ecoreElement.getSelection();
        if (ecoreBehavior instanceof OpaqueBehavior) {
            String objingBehavior = "";
            for (Object body : ((OpaqueBehavior)ecoreBehavior).getBodies()) {
                objingBehavior = objingBehavior.concat((String)body);
            }
            flow.setSelectionBehavior(objingBehavior);
        } else if (ecoreBehavior != null && (behaviorName = ecoreBehavior.getName()) != null) {
            flow.setSelectionBehavior(behaviorName);
        }
    }

    private void setTransformationBehavior(IObjectFlow flow) {
        String behaviorName;
        Behavior ecoreBehavior = this.ecoreElement.getTransformation();
        if (ecoreBehavior instanceof OpaqueBehavior) {
            String objingBehavior = "";
            for (Object body : ((OpaqueBehavior)ecoreBehavior).getBodies()) {
                objingBehavior = objingBehavior.concat((String)body);
            }
            flow.setTransformationBehavior(objingBehavior);
        } else if (ecoreBehavior != null && (behaviorName = ecoreBehavior.getName()) != null) {
            flow.setTransformationBehavior(behaviorName);
        }
    }
}

