/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityAction;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IOutputPin;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.ObObjectNodeOrderingKindEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IGeneralClass;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.xmi.model.ecore.EPin;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Type;

public class EOutputPin
extends EPin
implements IEElement {
    private OutputPin ecoreElement;

    public IElement createObjingElt() {
        return Modelio.getInstance().getModelingSession().getModel().createOutputPin();
    }

    public EOutputPin(OutputPin element) {
        super((Pin)element);
        this.ecoreElement = element;
    }

    public void attach(IElement objingElt) {
        this.attachToAction(objingElt);
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        this.setControlType((IOutputPin)objingElt);
        this.setOrdering((IOutputPin)objingElt);
        this.setSelectionBehavior((IOutputPin)objingElt);
        this.setType((IOutputPin)objingElt);
        this.setState((IOutputPin)objingElt);
    }

    private void attachToAction(IElement objingElt) {
        Action ecoreAction = (Action)this.getEcoreElement().getOwner();
        Object objingAction = ReverseProperties.getInstance().getMappedElement((Element)ecoreAction);
        if (objingAction instanceof IActivityAction) {
            ((IOutputPin)objingElt).setOutputing((IActivityAction)objingAction);
        } else {
            XMILogs.getInstance().writelnInLog("owner of outputpin was " + objingAction.getClass().getSimpleName());
            objingElt.delete();
        }
    }

    private void setControlType(IOutputPin pin) {
        pin.setControlType(this.ecoreElement.isControlType());
    }

    private void setOrdering(IOutputPin pin) {
        switch (this.ecoreElement.getOrdering().getValue()) {
            case 3: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.F_I_F_O);
                break;
            }
            case 2: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.L_I_F_O);
                break;
            }
            case 1: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.ORDERED);
                break;
            }
            case 0: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.UNORDERED);
                break;
            }
            default: {
                pin.setOrdering(ObObjectNodeOrderingKindEnum.F_I_F_O);
            }
        }
    }

    private void setSelectionBehavior(IOutputPin pin) {
        String behaviorName;
        Behavior ecoreBehavior = this.ecoreElement.getSelection();
        if (ecoreBehavior instanceof OpaqueBehavior) {
            String objingBehavior = "";
            for (Object body : ((OpaqueBehavior)ecoreBehavior).getBodies()) {
                objingBehavior = objingBehavior.concat((String)body);
            }
            pin.setSelectionBehavior(objingBehavior);
        } else if (ecoreBehavior != null && (behaviorName = ecoreBehavior.getName()) != null) {
            pin.setSelectionBehavior(behaviorName);
        }
    }

    private void setType(IOutputPin pin) {
        Object objingType;
        Type ecoreType = this.ecoreElement.getType();
        if (ecoreType != null && (objingType = ReverseProperties.getInstance().getMappedElement((Element)ecoreType)) instanceof IGeneralClass) {
            pin.setType((IGeneralClass)objingType);
        }
    }

    private void setState(IOutputPin pin) {
        Object objingState;
        State ecoreState;
        EList ecoreStates = this.ecoreElement.getInStates();
        if (ecoreStates != null && ecoreStates.size() > 0 && (ecoreState = (State)ecoreStates.get(0)) != null && (objingState = ReverseProperties.getInstance().getMappedElement((Element)ecoreState)) instanceof IState) {
            pin.setInState((IState)objingState);
        }
    }
}

