/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.model.uml.statik.IPackageImport;
import com.modeliosoft.modelio.api.model.uml.statik.ObVisibilityModeEnum;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.model.ecore.EElement;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import java.util.List;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;

public class EPackageImport
extends EElement
implements IEElement {
    private PackageImport ecoreElement;

    public IElement createObjingElt() {
        ReverseProperties revProp = ReverseProperties.getInstance();
        Package ecoreImported = this.ecoreElement.getImportedPackage();
        Package model = EcoreModelNavigation.getRoot((Package)ecoreImported);
        if (model != null && revProp.getEcoreModel().contains(model)) {
            return Modelio.getInstance().getModelingSession().getModel().createPackageImport();
        }
        return null;
    }

    public EPackageImport(PackageImport element) {
        super((Element)element);
        this.ecoreElement = element;
    }

    public void attach(IElement objingElt) {
        ReverseProperties revProp = ReverseProperties.getInstance();
        Package ecoreImported = this.ecoreElement.getImportedPackage();
        Namespace ecoreImporting = this.ecoreElement.getImportingNamespace();
        IPackage objingImported = (IPackage)revProp.getMappedElement((Element)ecoreImported);
        IModelElement objingImporting = (IModelElement)revProp.getMappedElement((Element)ecoreImporting);
        Package model = EcoreModelNavigation.getRoot((Package)ecoreImported);
        if (model != null && revProp.getEcoreModel().contains(model)) {
            IPackageImport objingPkgImport;
            if (objingImported != null && objingImporting != null) {
                objingPkgImport = (IPackageImport)objingElt;
                objingPkgImport.setImportedPackage(objingImported);
                if (objingImporting instanceof IOperation) {
                    objingPkgImport.setImportingOperation((IOperation)objingImporting);
                } else {
                    objingPkgImport.setImportingNameSpace((INameSpace)objingImporting);
                }
            }
            if (objingImported != null) {
                objingPkgImport = (IPackageImport)objingElt;
                objingPkgImport.setImportedPackage(objingImported);
                if (objingImporting != null) {
                    if (objingImporting instanceof INameSpace) {
                        objingPkgImport.setImportingNameSpace((INameSpace)objingImporting);
                    } else {
                        objingPkgImport.setImportingOperation((IOperation)objingImporting);
                    }
                }
            } else {
                String ownerName = "";
                if (ecoreImported != null) {
                    ownerName = ecoreImported.getName();
                }
                XMILogs xmilogs = XMILogs.getInstance();
                xmilogs.writelnInLog(XMI.I18N.getMessage("logFile.warning.unimportedElement.importPackage.ownerNull", new String[]{ownerName}));
                objingElt.delete();
            }
        } else {
            objingElt.delete();
            objingImported.delete();
        }
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        try {
            ReverseProperties revProp = ReverseProperties.getInstance();
            this.setVisibility((IPackageImport)objingElt);
            if (revProp.isRoundtripEnabled()) {
                this.setNameFromEAnnotation((IPackageImport)objingElt);
            }
        }
        catch (ObElementNotFoundException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
        }
        super.setProperties(objingElt);
    }

    private void setNameFromEAnnotation(IPackageImport objingElt) {
        if (ObjingEAnnotation.getName((Element)this.ecoreElement) != null) {
            objingElt.setName(ObjingEAnnotation.getName((Element)this.ecoreElement));
        }
    }

    private void setVisibility(IPackageImport objingElt) {
        switch (this.ecoreElement.getVisibility().getValue()) {
            case 0: {
                objingElt.setVisibility(ObVisibilityModeEnum.PUBLIC);
                break;
            }
            case 1: {
                objingElt.setVisibility(ObVisibilityModeEnum.PRIVATE);
                break;
            }
            default: {
                objingElt.setVisibility(ObVisibilityModeEnum.PUBLIC);
                XMILogs.getInstance().writelnInLog(XMI.I18N.getMessage("logFile.warning.wrongVisibility", new String[]{"", "PackageImport", ObVisibilityModeEnum.PUBLIC.toString()}));
            }
        }
        if (ObjingEAnnotation.isUndefined((Element)this.ecoreElement)) {
            objingElt.setVisibility(ObVisibilityModeEnum.VISIBILITY_UNDEFINED);
        }
    }
}

