/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IConnectorEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IInterface;
import com.modeliosoft.modelio.api.model.uml.statik.ILinkEnd;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPort;
import com.modeliosoft.modelio.api.model.uml.statik.IProvidedInterface;
import com.modeliosoft.modelio.api.model.uml.statik.IRequiredInterface;
import com.modeliosoft.modelio.api.model.uml.statik.ObPortOrientationEnum;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.xmi.model.ecore.EFeature;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;

public class EPort
extends EFeature
implements IEElement {
    private Port ecoreElement;

    public IElement createObjingElt() {
        return Modelio.getInstance().getModelingSession().getModel().createPort();
    }

    public EPort(Port element) {
        super((Feature)element);
        this.ecoreElement = element;
    }

    public void attach(IElement objingElt) {
        ObjingModelNavigation.attachPort((IElement)objingElt, (Port)this.ecoreElement);
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        this.setBehavior((IPort)objingElt);
        this.setService((IPort)objingElt);
        this.setRequiredInterfaces((IPort)objingElt);
        this.setProvidedInterfaces((IPort)objingElt);
        this.setType((IPort)objingElt);
        this.setEnd((IPort)objingElt);
        this.setRedefinedPort((IPort)objingElt);
        if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            this.setInterfaces((IPort)objingElt);
            this.setPortDirection((IPort)objingElt);
        }
    }

    private void setType(IPort objingElt) {
        Type type = this.ecoreElement.getType();
        if (type != null) {
            IElement objType = (IElement)ReverseProperties.getInstance().getMappedElement((Element)type);
            if (objType instanceof INameSpace) {
                objingElt.setBase((INameSpace)objType);
            }
            if (type instanceof IInterface) {
                boolean found = false;
                for (IProvidedInterface provided : objingElt.getProvided()) {
                    if (provided.getProvidedElement().size() != 1 || !((IInterface)provided.getProvidedElement().get(0)).equals((Object)objType)) continue;
                    found = true;
                }
                if (!found) {
                    IProvidedInterface provider = Modelio.getInstance().getModelingSession().getModel().createProvidedInterface();
                    objingElt.addProvided(provider);
                    provider.setProviding(objingElt);
                    provider.addProvidedElement((IInterface)type);
                }
            }
        }
    }

    private void setInterfaces(IPort objingElt) {
        Integer temp = ObjingEAnnotation.getNumberProvidedInterface((Element)this.ecoreElement);
        int i = 0;
        while (i < temp) {
            IProvidedInterface providedInterface = Modelio.getInstance().getModelingSession().getModel().createProvidedInterface();
            providedInterface.setProviding(objingElt);
            objingElt.addProvided(providedInterface);
            ++i;
        }
        temp = ObjingEAnnotation.getNumberRequiredInterface((Element)this.ecoreElement);
        i = 0;
        while (i < temp) {
            IRequiredInterface requiredInterface = Modelio.getInstance().getModelingSession().getModel().createRequiredInterface();
            requiredInterface.setRequiring(objingElt);
            objingElt.addRequired(requiredInterface);
            ++i;
        }
    }

    private void setProvidedInterfaces(IPort objingElt) {
        Type type = this.ecoreElement.getType();
        if (type != null && type instanceof BehavioredClassifier) {
            BehavioredClassifier behaClass = (BehavioredClassifier)type;
            for (Object object : behaClass.getInterfaceRealizations()) {
                if (!(object instanceof InterfaceRealization)) continue;
                InterfaceRealization interfaceRealization = (InterfaceRealization)object;
                IProvidedInterface providedInterface = null;
                Object temp = ReverseProperties.getInstance().getMappedElement((Element)interfaceRealization.getContract());
                if (!(temp instanceof IInterface)) continue;
                providedInterface = Modelio.getInstance().getModelingSession().getModel().createProvidedInterface();
                providedInterface.setProviding(objingElt);
                providedInterface.addProvidedElement((IInterface)temp);
                objingElt.addProvided(providedInterface);
            }
        }
    }

    private void setRequiredInterfaces(IPort objingElt) {
        Type type = this.ecoreElement.getType();
        if (type != null) {
            this.setRequiredInterface(objingElt, type);
            if (type instanceof Classifier) {
                for (Object superType : ((Classifier)type).getGenerals()) {
                    this.setRequiredInterface(objingElt, (Type)superType);
                }
            }
        }
    }

    private void setRequiredInterface(IPort objingElt, Type type) {
        for (Object object : type.getSourceDirectedRelationships()) {
            if (!(object instanceof Usage)) continue;
            Usage usage = (Usage)object;
            ArrayList<IRequiredInterface> usages = new ArrayList<IRequiredInterface>();
            for (Object supplier : usage.getSuppliers()) {
                Object objSupplier = ReverseProperties.getInstance().getMappedElement((Element)supplier);
                if (!(objSupplier instanceof IInterface)) continue;
                IRequiredInterface requiredInterface = Modelio.getInstance().getModelingSession().getModel().createRequiredInterface();
                requiredInterface.setRequiring(objingElt);
                requiredInterface.addRequiredElement((IInterface)objSupplier);
                objingElt.addRequired(requiredInterface);
                usages.add(requiredInterface);
            }
            TotalImportMap.getInstance().put((Object)usage, usages);
        }
    }

    private void setEnd(IPort objingElt) {
        for (Object end : this.ecoreElement.getEnds()) {
            ConnectorEnd connectorEnd;
            Property prop;
            if (!(end instanceof ConnectorEnd) || (prop = (connectorEnd = (ConnectorEnd)end).getPartWithPort()) == null) continue;
            IPort portClone = this.clonePort(objingElt);
            Object objOwner = ReverseProperties.getInstance().getMappedElement((Element)prop);
            if (objOwner instanceof IInstance) {
                ((IInstance)objOwner).addPart((IBindableInstance)portClone);
            } else if (objOwner instanceof ArrayList) {
                for (IModelElement objElt : (ArrayList)objOwner) {
                    if (!(objElt instanceof IInstance)) continue;
                    ((IInstance)objElt).addPart((IBindableInstance)portClone);
                }
            }
            Object objConnectorEnd = ReverseProperties.getInstance().getMappedElement((Element)connectorEnd);
            if (!(objConnectorEnd instanceof IConnectorEnd)) continue;
            portClone.addConnection((ILinkEnd)((IConnectorEnd)objConnectorEnd));
        }
    }

    private IPort clonePort(IPort objingElt) {
        IPort result = Modelio.getInstance().getModelingSession().getModel().createPort();
        result.setRepresentedFeature((IModelElement)objingElt);
        for (IProvidedInterface provided : objingElt.getProvided()) {
            result.addProvided((IProvidedInterface)Modelio.getInstance().getModelManipulationService().clone((IElement)provided));
        }
        for (IRequiredInterface required : objingElt.getRequired()) {
            result.addRequired((IRequiredInterface)Modelio.getInstance().getModelManipulationService().clone((IElement)required));
        }
        result.setBehavior(objingElt.isBehavior());
        result.setService(objingElt.isService());
        result.setName(objingElt.getName());
        result.setBase(objingElt.getBase());
        result.setValue(objingElt.getValue());
        result.setMultiplicityMax(objingElt.getMultiplicityMax());
        result.setMultiplicityMin(objingElt.getMultiplicityMin());
        result.setConstant(objingElt.isConstant());
        return result;
    }

    private void setRedefinedPort(IPort objingElt) {
        Object redefinedPort;
        EList redefinedPorts = this.ecoreElement.getRedefinedPorts();
        if (redefinedPorts != null && redefinedPorts.size() > 0 && (redefinedPort = ReverseProperties.getInstance().getMappedElement((Element)redefinedPorts.get(0))) instanceof IModelElement) {
            objingElt.setRepresentedFeature((IModelElement)redefinedPort);
        }
    }

    private void setBehavior(IPort objingElt) {
        objingElt.setBehavior(this.ecoreElement.isBehavior());
    }

    private void setService(IPort objingElt) {
        objingElt.setService(this.ecoreElement.isService());
    }

    private void setPortDirection(IPort objingElt) {
        String direction = ObjingEAnnotation.getPortDirection((Element)this.ecoreElement);
        objingElt.setDirection(ObPortOrientationEnum.valueOf((String)direction));
    }
}

