/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore;

import com.modeliosoft.modelio.api.model.uml.behavior.common.IBehavior;
import com.modeliosoft.modelio.api.model.uml.behavior.common.ISignal;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IEvent;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IInternalTransition;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IState;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateVertex;
import com.modeliosoft.modelio.api.model.uml.behavior.state.ITransition;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.xmi.model.ecore.ENamedElement;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.ProtocolTransition;
import org.eclipse.uml2.uml.SendOperationEvent;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Vertex;

public class ETransition
extends ENamedElement
implements IEElement {
    private boolean isInternalTransition;
    private Transition ecoreElement;

    public IElement createObjingElt() {
        if (this.isInternalTransition) {
            return Modelio.getInstance().getModelingSession().getModel().createInternalTransition();
        }
        return Modelio.getInstance().getModelingSession().getModel().createTransition();
    }

    public ETransition(Transition element) {
        super((NamedElement)element);
        this.ecoreElement = element;
        this.isInternalTransition = EcoreModelNavigation.isInternalTransition((Transition)element);
    }

    public void attach(IElement objingElt) {
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        super.setProperties(objingElt);
        if (!this.isInternalTransition) {
            this.setTarget((ITransition)objingElt);
        }
        this.setSource((ITransition)objingElt);
        this.setEffects((ITransition)objingElt);
        this.setTrigger((ITransition)objingElt);
        this.setPost((ITransition)objingElt);
        this.setGuard((ITransition)objingElt);
        if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            this.setReceivedEvent((ITransition)objingElt);
            this.setSentEvents((ITransition)objingElt);
            this.setEffect((ITransition)objingElt);
        }
    }

    private void setEffect(ITransition objingElt) {
        String effect = ObjingEAnnotation.getEffect((Element)this.ecoreElement);
        if (effect != null) {
            objingElt.setEffect(effect);
        }
    }

    private void setSentEvents(ITransition objingElt) {
        String signalString = ObjingEAnnotation.getSignal((Element)this.ecoreElement);
        if (signalString != null) {
            objingElt.setSentEvents(signalString);
        }
    }

    private void setReceivedEvent(ITransition objingElt) {
        String receivedEvent = ObjingEAnnotation.getReceivedEvent((Element)this.ecoreElement);
        if (receivedEvent != null) {
            if (objingElt instanceof IInternalTransition) {
                objingElt.setReceivedEvents(receivedEvent);
            } else {
                objingElt.setReceivedEvents(receivedEvent);
            }
        }
    }

    private void setGuard(ITransition objingElt) {
        Constraint guardConstraint = this.ecoreElement.getGuard();
        String guard = null;
        if (guardConstraint != null) {
            guard = guardConstraint.getName();
        }
        if (guard != null) {
            objingElt.setGuard(guard);
        }
    }

    private void setPost(ITransition objingElt) {
        String post = null;
        if (this.ecoreElement instanceof ProtocolTransition) {
            Constraint postConstraint = ((ProtocolTransition)this.ecoreElement).getPostCondition();
            if (postConstraint != null) {
                post = postConstraint.getName();
            }
        } else if (ReverseProperties.getInstance().isRoundtripEnabled()) {
            post = ObjingEAnnotation.getPostCondition((Element)this.ecoreElement);
        }
        if (post != null) {
            objingElt.setPostCondition(post);
        }
    }

    private void setSource(ITransition transition) {
        Object objingSource;
        Vertex ecoreSource = this.ecoreElement.getSource();
        if (ecoreSource != null && (objingSource = ReverseProperties.getInstance().getMappedElement((Element)ecoreSource)) instanceof IStateVertex) {
            if (this.isInternalTransition && objingSource instanceof IState) {
                ((IInternalTransition)transition).setSComposed((IState)objingSource);
            } else {
                transition.setSource((IStateVertex)objingSource);
            }
        }
    }

    private void setTarget(ITransition transition) {
        Object objingTarget;
        Vertex ecoreTarget = this.ecoreElement.getTarget();
        if (ecoreTarget != null && (objingTarget = ReverseProperties.getInstance().getMappedElement((Element)ecoreTarget)) instanceof IStateVertex) {
            transition.setTarget((IStateVertex)objingTarget);
        }
    }

    private void setEffects(ITransition transition) {
        String signal;
        Behavior behavior = this.ecoreElement.getEffect();
        if (behavior instanceof OpaqueBehavior) {
            for (Object clientDependency : behavior.getClientDependencies()) {
                for (Object ecoreSupplier : ((Dependency)clientDependency).getSuppliers()) {
                    Object objingSupplier;
                    if (!(ecoreSupplier instanceof Signal) || !((objingSupplier = ReverseProperties.getInstance().getMappedElement((Element)((Signal)ecoreSupplier))) instanceof ISignal)) continue;
                    transition.setEffects((ISignal)objingSupplier);
                    return;
                }
            }
        }
        if (ReverseProperties.getInstance().isRoundtripEnabled() && (signal = ObjingEAnnotation.getSignal((Element)this.ecoreElement)) != null) {
            transition.setEffect(signal);
        }
    }

    private void setTrigger(ITransition transition) {
        Trigger ecoreTrigger;
        Event ecoreEvent;
        EList ecoreTriggerList = this.ecoreElement.getTriggers();
        if (ecoreTriggerList.size() > 0 && (ecoreEvent = (ecoreTrigger = (Trigger)ecoreTriggerList.get(0)).getEvent()) != null) {
            if (ecoreEvent instanceof SendOperationEvent) {
                this.setTriggerEvent(transition, (SendOperationEvent)ecoreEvent);
            } else if (ecoreEvent instanceof ChangeEvent) {
                this.setReceivedEvent(transition, (ChangeEvent)ecoreEvent);
            } else {
                this.setEvent(transition, ecoreEvent);
            }
        }
    }

    private void setTriggerEvent(ITransition transition, SendOperationEvent ecoreEvent) {
        Operation ecoreOp = ecoreEvent.getOperation();
        if (ecoreOp != null) {
            StateMachine ecoreSM = EcoreModelNavigation.getMostEnclosingStateMachine((Transition)this.ecoreElement);
            Object objingSM = ReverseProperties.getInstance().getMappedElement((Element)ecoreSM);
            Object objingOp = ReverseProperties.getInstance().getMappedElement((Element)ecoreOp);
            if (objingSM instanceof IStateMachine && objingOp instanceof IOperation) {
                IEvent objingEvent = Modelio.getInstance().getModelingSession().getModel().createEvent();
                objingEvent.setComposed((IBehavior)((IStateMachine)objingSM));
                transition.setTrigger(objingEvent);
                String name = ecoreEvent.getName();
                if (EcoreModelNavigation.isNotNull((String)name)) {
                    objingEvent.setName(name);
                } else {
                    objingEvent.setName("");
                }
                objingEvent.setCalled((IOperation)objingOp);
            }
        }
    }

    private void setReceivedEvent(ITransition transition, ChangeEvent event) {
        IEvent objEvent = (IEvent)ReverseProperties.getInstance().getMappedElement((Element)event);
        transition.setTrigger(objEvent);
    }

    private void setEvent(ITransition transition, Event ecoreEvent) {
        IEvent objEvent = (IEvent)ReverseProperties.getInstance().getMappedElement((Element)ecoreEvent);
        transition.setTrigger(objEvent);
    }
}

