/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore.sequence;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IExecutionSpecification;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionOperand;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObRelativeTimeEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidInteractionManipulationException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.model.ecore.sequence.SequenceElementImportMapper;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class BehaviorExecutionSpecificationImportMapper
extends SequenceElementImportMapper
implements IEElement {
    private ReverseProperties revProp;
    private BehaviorExecutionSpecification ecoreElement;
    private OccurrenceSpecification ecoreStart;
    private OccurrenceSpecification ecoreFinish;

    public Object createObjingElt() {
        return Modelio.getInstance().getModelingSession().getModel().createExecutionSpecification();
    }

    public BehaviorExecutionSpecificationImportMapper(BehaviorExecutionSpecification element) {
        super((NamedElement)element);
        this.ecoreElement = element;
        this.revProp = ReverseProperties.getInstance();
        this.ecoreStart = this.ecoreElement.getStart();
        this.ecoreFinish = this.ecoreElement.getFinish();
    }

    public List<String> getObjingClassName() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ExecutionSpecification");
        return result;
    }

    public void attach(IElement objingElt) {
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        this.setName((IModelElement)((IExecutionSpecification)objingElt));
        this.insertInDiagram((IExecutionSpecification)objingElt);
        this.setStartAndEndElement((IExecutionSpecification)objingElt);
    }

    public void setStartAndEndElement(IExecutionSpecification objingElt) {
        String name = this.ecoreStart.getName();
        if (name != null) {
            objingElt.getStart().setName(name);
        }
        if ((name = this.ecoreFinish.getName()) != null) {
            objingElt.getFinish().setName(name);
        }
        TotalImportMap totalCreationMap = TotalImportMap.getInstance();
        totalCreationMap.put((Object)this.ecoreStart, (Object)objingElt.getStart());
        totalCreationMap.put((Object)this.ecoreFinish, (Object)objingElt.getFinish());
    }

    private void insertInDiagram(IExecutionSpecification specification) {
        ILifeline oCoveredLL;
        Lifeline eCoveredLL = (Lifeline)this.ecoreElement.getCovereds().get(0);
        if (eCoveredLL != null && (oCoveredLL = (ILifeline)this.revProp.getMappedElement((Element)eCoveredLL)) != null) {
            InteractionFragment ecoreEnclosing = EcoreModelNavigation.getEnclosing((InteractionFragment)this.ecoreElement);
            InteractionFragment ecoreBeforeStart = null;
            if (this.ecoreStart != null) {
                ecoreBeforeStart = this.getEndBeforeStart(ecoreEnclosing);
            }
            InteractionFragment ecoreBeforeFinish = null;
            if (this.ecoreFinish != null) {
                ecoreBeforeFinish = this.getEndBeforeFinish(ecoreEnclosing);
            }
            IInteractionFragment objingBeforeStart = null;
            IInteractionFragment objingBeforeFinish = null;
            if (ecoreBeforeStart != null) {
                IModelElement oBeforeStart = (IModelElement)this.revProp.getMappedElement((Element)ecoreBeforeStart);
                objingBeforeStart = !(oBeforeStart instanceof IInteractionFragment) ? ObjingModelNavigation.getConnectedFragment((IModelElement)oBeforeStart) : (IInteractionFragment)oBeforeStart;
            }
            if (ecoreBeforeFinish != null && this.ecoreStart != null && this.ecoreFinish != null && !ecoreBeforeFinish.equals(this.ecoreStart) && !ecoreBeforeFinish.equals(this.ecoreElement)) {
                IModelElement oBeforeFinish = (IModelElement)this.revProp.getMappedElement((Element)ecoreBeforeFinish);
                objingBeforeFinish = !(oBeforeFinish instanceof IInteractionFragment) ? ObjingModelNavigation.getConnectedFragment((IModelElement)oBeforeFinish) : (IInteractionFragment)oBeforeFinish;
            }
            try {
                if (this.endsAreInserted(ecoreBeforeStart, ecoreBeforeFinish)) {
                    this.addSpecification(ecoreEnclosing, specification, oCoveredLL, objingBeforeStart, objingBeforeFinish);
                } else {
                    this.insertSpecification(ecoreEnclosing, specification, oCoveredLL, objingBeforeStart);
                }
            }
            catch (Exception e) {
                LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
                PartialImportMap.getInstance().remove((Object)this.ecoreElement);
                TotalImportMap.getInstance().remove((Object)this.ecoreElement);
                specification.delete();
            }
        }
    }

    private boolean endsAreInserted(InteractionFragment beforeStart, InteractionFragment beforeFinish) {
        TotalImportMap totalCreationMap;
        return beforeStart != null && beforeFinish != null && (totalCreationMap = TotalImportMap.getInstance()).get((Object)beforeStart) != null && totalCreationMap.get((Object)beforeFinish) != null;
    }

    private InteractionFragment getEndBeforeStart(InteractionFragment ecoreEnclosing) {
        InteractionFragment ecoreBeforeStart = null;
        if (ecoreEnclosing instanceof Interaction) {
            ecoreBeforeStart = EcoreModelNavigation.getPreviousFragmentInInteraction((InteractionFragment)this.ecoreStart);
        } else if (ecoreEnclosing instanceof InteractionOperand) {
            ecoreBeforeStart = EcoreModelNavigation.getPreviousFragmentInOperand((InteractionFragment)this.ecoreStart);
        }
        return ecoreBeforeStart;
    }

    private InteractionFragment getEndBeforeFinish(InteractionFragment ecoreEnclosing) {
        InteractionFragment ecoreBeforeEnd = null;
        if (ecoreEnclosing instanceof Interaction) {
            ecoreBeforeEnd = EcoreModelNavigation.getPreviousFragmentInInteraction((InteractionFragment)this.ecoreFinish);
        } else if (ecoreEnclosing instanceof InteractionOperand) {
            ecoreBeforeEnd = EcoreModelNavigation.getPreviousFragmentInOperand((InteractionFragment)this.ecoreFinish);
        }
        return ecoreBeforeEnd;
    }

    private void addSpecification(InteractionFragment ecoreEnclosing, IExecutionSpecification specification, ILifeline coveredLL, IInteractionFragment objingBeforeStart, IInteractionFragment objingBeforeFinish) throws InvalidInteractionManipulationException {
        IModelElement objingEnclosing = (IModelElement)this.revProp.getMappedElement((Element)ecoreEnclosing);
        if (objingEnclosing instanceof IInteraction) {
            ((IInteraction)objingEnclosing).add(specification, coveredLL, objingBeforeStart, ObRelativeTimeEnum.AFTER, objingBeforeFinish, ObRelativeTimeEnum.AFTER);
        } else if (objingEnclosing instanceof IInteractionOperand) {
            ((IInteractionOperand)objingEnclosing).add(specification, coveredLL, objingBeforeStart, ObRelativeTimeEnum.AFTER, objingBeforeFinish, ObRelativeTimeEnum.AFTER);
        }
    }

    private void insertSpecification(InteractionFragment ecoreEnclosing, IExecutionSpecification specification, ILifeline coveredLL, IInteractionFragment objingPrevious) throws InvalidInteractionManipulationException {
        IModelElement objingEnclosing = (IModelElement)this.revProp.getMappedElement((Element)ecoreEnclosing);
        if (objingEnclosing instanceof IInteraction) {
            ((IInteraction)objingEnclosing).insert(specification, coveredLL, objingPrevious, ObRelativeTimeEnum.AFTER);
        } else if (objingEnclosing instanceof IInteractionOperand) {
            if (objingPrevious != null) {
                ((IInteractionOperand)objingEnclosing).insert(specification, coveredLL, objingPrevious, ObRelativeTimeEnum.AFTER);
            } else {
                ((IInteractionOperand)objingEnclosing).insert(specification, coveredLL, (IInteractionFragment)((IInteractionOperand)objingEnclosing), ObRelativeTimeEnum.DURING);
            }
        }
    }
}

