/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.ecore.sequence;

import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ICombinedFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionFragment;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteractionOperand;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ILifeline;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObInteractionOperatorEnum;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.ObRelativeTimeEnum;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidInteractionManipulationException;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.xmi.model.ecore.IEElement;
import com.modeliosoft.modelio.xmi.model.ecore.sequence.SequenceElementImportMapper;
import com.modeliosoft.modelio.xmi.reverse.PartialImportMap;
import com.modeliosoft.modelio.xmi.reverse.TotalImportMap;
import com.modeliosoft.modelio.xmi.util.EcoreModelNavigation;
import com.modeliosoft.modelio.xmi.util.NotFoundException;
import com.modeliosoft.modelio.xmi.util.ReverseProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;

public class CombinedFragmentImportMapper
extends SequenceElementImportMapper
implements IEElement {
    private CombinedFragment ecoreElement;

    public Object createObjingElt() {
        return Modelio.getInstance().getModelingSession().getModel().createCombinedFragment();
    }

    private List<ILifeline> getCoveredLifelines() {
        ReverseProperties revProp = ReverseProperties.getInstance();
        ArrayList<ILifeline> oCoveredList = new ArrayList<ILifeline>();
        for (Object eCoveredLL : this.ecoreElement.getCovereds()) {
            ILifeline oCoveredLL = (ILifeline)revProp.getMappedElement((Element)((Lifeline)eCoveredLL));
            if (oCoveredLL == null) continue;
            oCoveredList.add(oCoveredLL);
        }
        return oCoveredList;
    }

    public CombinedFragmentImportMapper(CombinedFragment element) {
        super((NamedElement)element);
        this.ecoreElement = element;
    }

    public List<String> getObjingClassName() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("CombinedFragment");
        return result;
    }

    public void attach(IElement objingElt) {
    }

    public void attach(List<Object> objingElts) {
    }

    public void setProperties(IElement objingElt) {
        if (objingElt instanceof ICombinedFragment) {
            this.setName((IModelElement)((ICombinedFragment)objingElt));
            this.setOperand((ICombinedFragment)objingElt);
            this.insertInDiagram((ICombinedFragment)objingElt);
        }
    }

    private void setOperand(ICombinedFragment fragment) {
        InteractionOperatorKind kindOfOperator = this.ecoreElement.getInteractionOperator();
        switch (kindOfOperator.getValue()) {
            case 1: {
                fragment.setOperator(ObInteractionOperatorEnum.ALT_OP);
                break;
            }
            case 9: {
                fragment.setOperator(ObInteractionOperatorEnum.ASSERT_OP);
                break;
            }
            case 3: {
                fragment.setOperator(ObInteractionOperatorEnum.BREAK_OP);
                break;
            }
            case 11: {
                fragment.setOperator(ObInteractionOperatorEnum.CONSIDER_OP);
                break;
            }
            case 7: {
                fragment.setOperator(ObInteractionOperatorEnum.CRITICAL_OP);
                break;
            }
            case 10: {
                fragment.setOperator(ObInteractionOperatorEnum.IGNORE_OP);
                break;
            }
            case 6: {
                fragment.setOperator(ObInteractionOperatorEnum.LOOP_OP);
                break;
            }
            case 8: {
                fragment.setOperator(ObInteractionOperatorEnum.NEG_OP);
                break;
            }
            case 2: {
                fragment.setOperator(ObInteractionOperatorEnum.OPT_OP);
                break;
            }
            case 4: {
                fragment.setOperator(ObInteractionOperatorEnum.PAR_OP);
                break;
            }
            case 0: {
                fragment.setOperator(ObInteractionOperatorEnum.SEQ_OP);
                break;
            }
            case 5: {
                fragment.setOperator(ObInteractionOperatorEnum.STRICT_OP);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertInDiagram(ICombinedFragment fragment) {
        ReverseProperties revProp = ReverseProperties.getInstance();
        List oCoveredLLs = this.getCoveredLifelines();
        if (oCoveredLLs.size() > 0) {
            Interaction ecoreInt = EcoreModelNavigation.getMostEnclosingInteraction((InteractionFragment)this.ecoreElement);
            IInteraction objingInt = (IInteraction)revProp.getMappedElement((Element)ecoreInt);
            InteractionFragment ecoreEnclosing = EcoreModelNavigation.getEnclosing((InteractionFragment)this.ecoreElement);
            if (ecoreEnclosing instanceof Interaction) {
                InteractionFragment ecorePrevious = EcoreModelNavigation.getPreviousFragmentInInteraction((InteractionFragment)this.ecoreElement);
                IInteractionFragment objingPrevious = null;
                if (ecorePrevious != null) {
                    objingPrevious = (IInteractionFragment)revProp.getMappedElement((Element)ecorePrevious);
                }
                this.insertCFInInteraction(objingInt, fragment, oCoveredLLs, objingPrevious, ObRelativeTimeEnum.AFTER);
                return;
            } else {
                if (!(ecoreEnclosing instanceof InteractionOperand)) throw new NotFoundException("CombinedFragments enclosed in " + ecoreEnclosing.getClass().getSimpleName() + " are not supported.");
                IInteractionOperand objingEnclosing = (IInteractionOperand)revProp.getMappedElement((Element)ecoreEnclosing);
                InteractionFragment ecorePrevious = EcoreModelNavigation.getPreviousFragmentInOperand((InteractionFragment)this.ecoreElement);
                IInteractionFragment objingPrevious = null;
                if (ecorePrevious != null) {
                    objingPrevious = (IInteractionFragment)revProp.getMappedElement((Element)ecorePrevious);
                }
                if (objingPrevious == null) {
                    this.insertCFInIO(objingEnclosing, fragment, oCoveredLLs, (IInteractionFragment)objingEnclosing, ObRelativeTimeEnum.DURING);
                    return;
                } else {
                    this.insertCFInIO(objingEnclosing, fragment, oCoveredLLs, objingPrevious, ObRelativeTimeEnum.AFTER);
                }
            }
            return;
        } else {
            PartialImportMap.getInstance().remove((Object)this.ecoreElement);
            TotalImportMap.getInstance().remove((Object)this.ecoreElement);
            fragment.delete();
        }
    }

    private void insertCFInInteraction(IInteraction objingInt, ICombinedFragment fragment, List<ILifeline> coveredLLs, IInteractionFragment previousIF, ObRelativeTimeEnum relativeTime) {
        try {
            objingInt.insert(fragment, coveredLLs, previousIF, relativeTime);
        }
        catch (InvalidInteractionManipulationException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            PartialImportMap.getInstance().remove((Object)this.ecoreElement);
            TotalImportMap.getInstance().remove((Object)this.ecoreElement);
            fragment.delete();
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            PartialImportMap.getInstance().remove((Object)this.ecoreElement);
            TotalImportMap.getInstance().remove((Object)this.ecoreElement);
            fragment.delete();
        }
    }

    private void insertCFInIO(IInteractionOperand intOperand, ICombinedFragment fragment, List<ILifeline> coveredLLs, IInteractionFragment previousIF, ObRelativeTimeEnum relativeTime) {
        try {
            intOperand.insert(fragment, coveredLLs, previousIF, relativeTime);
        }
        catch (InvalidInteractionManipulationException e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            PartialImportMap.getInstance().remove((Object)this.ecoreElement);
            TotalImportMap.getInstance().remove((Object)this.ecoreElement);
            fragment.delete();
        }
        catch (Exception e) {
            LOG.error((String)"org.modelio.xmi.internal", (Throwable)e);
            PartialImportMap.getInstance().remove((Object)this.ecoreElement);
            TotalImportMap.getInstance().remove((Object)this.ecoreElement);
            fragment.delete();
        }
    }
}

