/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.xmi.model.objing.OModelElement;
import com.modeliosoft.modelio.xmi.plugin.XMI;
import com.modeliosoft.modelio.xmi.util.CompositionOwnerVisitor;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.NotFoundException;
import com.modeliosoft.modelio.xmi.util.ObjingEAnnotation;
import com.modeliosoft.modelio.xmi.util.XMILogs;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLFactory;

public class OActivity
extends OModelElement {
    private IActivity objingElement;

    public Element createEcoreElt() {
        return UMLFactory.eINSTANCE.createActivity();
    }

    public OActivity(IActivity element) {
        super((IModelElement)element);
        this.objingElement = element;
    }

    public void attach(Element ecoreElt, CompositionOwnerVisitor ownerVisitor) {
        IElement objingOwner;
        GenerationProperties genProp = GenerationProperties.getInstance();
        Element ecoreOwner = genProp.getMappedElement(objingOwner = ownerVisitor.getCompositionOwner((IElement)this.objingElement));
        if (ecoreOwner != null) {
            if (objingOwner instanceof INameSpace && ecoreOwner instanceof Namespace) {
                this.attachToNameSpace(ecoreElt, (Namespace)ecoreOwner);
            } else if (objingOwner instanceof IOperation) {
                this.attachToOperation(ecoreElt, (IOperation)objingOwner);
            }
        }
    }

    public void setProperties(Element ecoreElt) {
        super.setProperties(ecoreElt);
        this.setReadOnly((Activity)ecoreElt);
        this.setSingleExecution((Activity)ecoreElt);
        this.setReentrant((Activity)ecoreElt);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void attachToNameSpace(Element ecoreElt, Namespace ecoreOwner) {
        String ownerId = ObjingEAnnotation.getOwner((Element)ecoreElt);
        if (ownerId != null && !ownerId.equals("")) {
            ObjingEAnnotation.deleteOwner((Element)ecoreElt);
            return;
        }
        if (ecoreOwner instanceof Package) {
            Package ownerIsPkg = (Package)ecoreOwner;
            ownerIsPkg.getPackagedElements().add((Object)((PackageableElement)ecoreElt));
            return;
        }
        if (ecoreOwner instanceof Component) {
            Component ownerIsCmpnt = (Component)ecoreOwner;
            ownerIsCmpnt.getPackagedElements().add((Object)((PackageableElement)ecoreElt));
            return;
        }
        if (ecoreOwner instanceof Class) {
            Class ownerIsClass = (Class)ecoreOwner;
            ownerIsClass.getOwnedBehaviors().add((Object)((Activity)ecoreElt));
            return;
        }
        if (ecoreOwner instanceof Interface) {
            Interface ownerIsItf = (Interface)ecoreOwner;
            ownerIsItf.getNestedClassifiers().add((Object)((Classifier)ecoreElt));
            return;
        }
        if (ecoreOwner instanceof BehavioredClassifier) {
            BehavioredClassifier ownerIsBehavioredClassifier = (BehavioredClassifier)ecoreOwner;
            ownerIsBehavioredClassifier.getOwnedBehaviors().add((Object)((Behavior)ecoreElt));
            return;
        }
        ecoreElt.destroy();
        throw new NotFoundException("Owner Class (" + ecoreOwner.getClass().getSimpleName() + ") Not Found");
    }

    private void attachToOperation(Element ecoreElt, IOperation objingOwner) {
        IClassifier objingOpOwner = objingOwner.getOwner();
        String errorMessage = XMI.I18N.getMessage("logFile.warning.moving.activity", new String[]{this.objingElement.getName(), objingOwner.getName(), objingOpOwner.getName()});
        XMILogs.getInstance().writelnInLog(errorMessage);
        GenerationProperties genProp = GenerationProperties.getInstance();
        genProp.getReportModel().addWarning(errorMessage, (IElement)this.objingElement);
        Element ecoreOpOwner = genProp.getMappedElement((IElement)objingOpOwner);
        if (!(ecoreOpOwner instanceof Namespace)) {
            ecoreElt.destroy();
            throw new NotFoundException("Owner Class (" + ecoreOpOwner.getClass().getSimpleName() + ") Not Found");
        }
        this.attachToNameSpace(ecoreElt, (Namespace)ecoreOpOwner);
    }

    private void setReadOnly(Activity activity) {
        activity.setIsReadOnly(this.objingElement.isReadOnly());
    }

    private void setSingleExecution(Activity activity) {
        activity.setIsSingleExecution(this.objingElement.isSingleExecution());
    }

    private void setReentrant(Activity activity) {
        activity.setIsReentrant(this.objingElement.isReentrant());
    }
}

