/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.xmi.model.objing;

import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivityPartition;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IClause;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IConditionalNode;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IStructuredActivityNode;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.xmi.model.objing.IOElement;
import com.modeliosoft.modelio.xmi.model.objing.OModelElement;
import com.modeliosoft.modelio.xmi.util.CompositionOwnerVisitor;
import com.modeliosoft.modelio.xmi.util.GenerationProperties;
import com.modeliosoft.modelio.xmi.util.NotFoundException;
import com.modeliosoft.modelio.xmi.util.ObjingModelNavigation;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Clause;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class OActivityNode
extends OModelElement
implements IOElement {
    CompositionOwnerVisitor ownerVisitor = null;

    public OActivityNode(IActivityNode element) {
        super((IModelElement)element);
    }

    public void attach(Element ecoreElt, CompositionOwnerVisitor ownerVisitor) {
        this.ownerVisitor = ownerVisitor;
        IElement objingOwner = ownerVisitor.getCompositionOwner(this.getObjingElement());
        Element ecoreOwner = GenerationProperties.getInstance().getMappedElement(objingOwner);
        if (ecoreOwner != null) {
            if (objingOwner instanceof IStructuredActivityNode) {
                this.attachToStructuredActivityNode(ecoreElt, ecoreOwner);
            } else if (objingOwner instanceof IActivityPartition) {
                this.attachToActivityPartition(ecoreElt, ecoreOwner);
            } else if (objingOwner instanceof IActivity) {
                this.attachToActivity(ecoreElt, ecoreOwner);
            } else if (objingOwner instanceof IClause) {
                this.attachToClause(ecoreElt, ecoreOwner, (IClause)objingOwner);
            }
        }
    }

    private void attachToStructuredActivityNode(Element ecoreElt, Element ecoreOwner) {
        if (!(ecoreOwner instanceof StructuredActivityNode)) {
            ecoreElt.destroy();
            throw new NotFoundException("Owner Class (" + ecoreOwner.getClass().getSimpleName() + ") Not Found");
        }
        StructuredActivityNode owner = (StructuredActivityNode)ecoreOwner;
        owner.getNodes().add((Object)((ActivityNode)ecoreElt));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void attachToActivityPartition(Element ecoreElt, Element ecoreOwner) {
        if (!(ecoreOwner instanceof ActivityPartition)) {
            ecoreElt.destroy();
            throw new NotFoundException("Owner Class (" + ecoreOwner.getClass().getSimpleName() + ") Not Found");
        }
        ActivityPartition owner = (ActivityPartition)ecoreOwner;
        owner.getNodes().add((Object)((ActivityNode)ecoreElt));
        IActivity enclosingActivity = (IActivity)ObjingModelNavigation.getEnclosingElement((IElement)this.getObjingElement(), IActivity.class, (CompositionOwnerVisitor)this.ownerVisitor);
        if (enclosingActivity == null) return;
        Element ecoreActivity = GenerationProperties.getInstance().getMappedElement((IElement)enclosingActivity);
        if (ecoreActivity != null) {
            this.attachToActivity(ecoreElt, ecoreActivity);
            return;
        }
        ecoreElt.destroy();
        throw new NotFoundException("Owner Class not found.");
    }

    private void attachToActivity(Element ecoreElt, Element ecoreOwner) {
        if (!(ecoreOwner instanceof Activity)) {
            ecoreElt.destroy();
            throw new NotFoundException("Owner Class (" + ecoreOwner.getClass().getSimpleName() + ") Not Found");
        }
        Activity owner = (Activity)ecoreOwner;
        owner.getNodes().add((Object)((ActivityNode)ecoreElt));
    }

    private void attachToClause(Element ecoreElt, Element ecoreOwner, IClause objingOwnerClause) {
        IActivity enclosingActivity;
        boolean isAttached = false;
        if (ecoreOwner instanceof Clause) {
            Element ecoreConditional;
            IConditionalNode objingConditional;
            Clause owner = (Clause)ecoreOwner;
            if (ecoreElt instanceof ExecutableNode) {
                owner.getBodies().add((Object)((ExecutableNode)ecoreElt));
            }
            if ((objingConditional = objingOwnerClause.getOwner()) != null && (ecoreConditional = GenerationProperties.getInstance().getMappedElement((IElement)objingConditional)) instanceof StructuredActivityNode) {
                ((StructuredActivityNode)ecoreConditional).getNodes().add((Object)((ActivityNode)ecoreElt));
                isAttached = true;
            }
        }
        if (!isAttached && (enclosingActivity = (IActivity)ObjingModelNavigation.getEnclosingElement((IElement)this.getObjingElement(), IActivity.class, (CompositionOwnerVisitor)this.ownerVisitor)) != null) {
            Element ecoreActivity = GenerationProperties.getInstance().getMappedElement((IElement)enclosingActivity);
            if (ecoreActivity != null) {
                this.attachToActivity(ecoreElt, ecoreActivity);
            } else {
                ecoreElt.destroy();
                throw new NotFoundException("Owner Class not found.");
            }
        }
    }

    public Element createEcoreElt() {
        return null;
    }

    public void setProperties(Element ecoreElt) {
        super.setProperties(ecoreElt);
    }
}

